/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.options;

import org.eclipse.escet.cif.simulator.options.InputMode;
import org.eclipse.escet.cif.simulator.options.InteractiveAutoChooseOption;
import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;

public class InputModeOption
extends EnumOption<InputMode> {
    public InputModeOption() {
        super("Input mode", "The input mode that determines the method by which the simulator can request input, such as which transition to choose. Specify \"interactive\" (deprecated) for interactive console input mode, \"console\" for interactive console input mode, \"gui\" (default) for interactive GUI input mode, \"auto\" for automatic input mode, \"trace\" for trace input mode, or \"svg\" for SVG input mode (requires the use of SVG visualization).", Character.valueOf('i'), "input-mode", "INPUTMODE", (Enum)InputMode.GUI, true, "The input mode that determines the method by which the simulator can request input, such as which transition to choose.");
    }

    public static InputMode getInputMode() {
        InputMode rslt = (InputMode)((Object)Options.get(InputModeOption.class));
        if (rslt == InputMode.INTERACTIVE) {
            rslt = InputMode.CONSOLE;
        }
        return rslt;
    }

    public static boolean isInteractive() {
        switch (InputModeOption.getInputMode()) {
            case AUTO: 
            case TRACE: 
            case SVG: {
                return false;
            }
            case CONSOLE: 
            case GUI: {
                return true;
            }
            case INTERACTIVE: {
                throw new RuntimeException("Should have been remapped.");
            }
        }
        throw new RuntimeException("Unknown input mode: " + (Object)((Object)InputModeOption.getInputMode()));
    }

    public static boolean isPurelyInteractive() {
        return InputModeOption.isInteractive() && !InteractiveAutoChooseOption.isSpecified();
    }

    protected String getDialogText(InputMode value) {
        switch (value) {
            case INTERACTIVE: {
                return "Interactive console input mode (deprecated)";
            }
            case CONSOLE: {
                return "Interactive console input mode";
            }
            case GUI: {
                return "Interactive GUI input mode";
            }
            case AUTO: {
                return "Automatic input mode";
            }
            case TRACE: {
                return "Trace input mode";
            }
            case SVG: {
                return "SVG input mode (requires the use of SVG visualization)";
            }
        }
        throw new RuntimeException("Unknown mode: " + (Object)((Object)value));
    }
}

