/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProcessPropertyPage
extends PropertyPage {
    private static Font fHeadingFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");

    protected Control createContents(Composite ancestor) {
        String[] arguments;
        int count;
        this.noDefaultAndApplyButton();
        Composite parent = SWTFactory.createComposite(ancestor, ancestor.getFont(), 1, 1, 1808);
        IProcess proc = this.getProcess();
        SWTFactory.createLabel(parent, DebugPreferencesMessages.ProcessPropertyPage_0, fHeadingFont, 1);
        Text text = SWTFactory.createText(parent, 8, 1);
        ((GridData)text.getLayoutData()).horizontalIndent = 10;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)text, "org.eclipse.debug.ui.process_page_run_at_time_widget");
        text.setText(this.getLaunchTimeText(proc));
        text.setBackground(parent.getBackground());
        SWTFactory.createVerticalSpacer(parent, 2);
        SWTFactory.createLabel(parent, DebugPreferencesMessages.ProcessPropertyPage_10, fHeadingFont, 1);
        text = SWTFactory.createText(parent, 8, 1);
        ((GridData)text.getLayoutData()).horizontalIndent = 10;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)text, "org.eclipse.debug.ui.process_page_terminate_at_time_widget");
        text.setText(this.getTerminateTimeText(proc));
        text.setBackground(parent.getBackground());
        SWTFactory.createVerticalSpacer(parent, 2);
        SWTFactory.createLabel(parent, DebugPreferencesMessages.ProcessPropertyPage_1, fHeadingFont, 1);
        text = SWTFactory.createText(parent, 72, 1);
        ((GridData)text.getLayoutData()).horizontalIndent = 10;
        text.setText(this.getPathText(proc));
        text.setBackground(parent.getBackground());
        SWTFactory.createVerticalSpacer(parent, 2);
        SWTFactory.createLabel(parent, DebugPreferencesMessages.ProcessPropertyPage_6, fHeadingFont, 1);
        text = SWTFactory.createText(parent, 72, 1);
        ((GridData)text.getLayoutData()).horizontalIndent = 10;
        text.setText(this.getWorkingDirectory(proc));
        text.setBackground(parent.getBackground());
        SWTFactory.createVerticalSpacer(parent, 2);
        SWTFactory.createLabel(parent, DebugPreferencesMessages.ProcessPropertyPage_Command_Line__1, fHeadingFont, 1);
        StyledText styledText = SWTFactory.createStyledText(parent, 2632, 1, this.convertWidthInCharsToPixels(13), this.convertHeightInCharsToPixels(10), 1808);
        styledText.setBackground(parent.getBackground());
        ((GridData)styledText.getLayoutData()).horizontalIndent = 10;
        String commandLineText = DebugPreferencesMessages.ProcessPropertyPage_5;
        if (proc != null && (count = (arguments = DebugPlugin.parseArguments((String)(commandLineText = proc.getAttribute(IProcess.ATTR_CMDLINE)))).length) > 1) {
            final int[] segments = new int[count - 1];
            commandLineText = DebugPlugin.renderArguments((String[])arguments, (int[])segments);
            styledText.addBidiSegmentListener(new BidiSegmentListener(){

                public void lineGetSegments(BidiSegmentEvent event) {
                    int offset = event.lineOffset;
                    int end = offset + event.lineText.length();
                    int iStart = Arrays.binarySearch(segments, offset);
                    if (iStart < 0) {
                        iStart = -iStart - 1;
                    }
                    int i = iStart;
                    while (i < segments.length && segments[i] < end) {
                        ++i;
                    }
                    int n = i - iStart;
                    if (n > 0) {
                        if (n == segments.length) {
                            event.segments = segments;
                        } else {
                            int[] lineSegments = new int[n];
                            System.arraycopy(segments, iStart, lineSegments, 0, n);
                            event.segments = lineSegments;
                        }
                        char[] chars = new char[n];
                        Arrays.fill(chars, '\n');
                        event.segmentsChars = chars;
                    }
                }
            });
        }
        if (commandLineText != null) {
            styledText.setText(commandLineText);
        }
        SWTFactory.createLabel(parent, DebugPreferencesMessages.ProcessPropertyPage_7, fHeadingFont, 1);
        text = SWTFactory.createText(parent, 2824, 1, this.convertWidthInCharsToPixels(13), this.convertHeightInCharsToPixels(8), 1808);
        text.setBackground(parent.getBackground());
        ((GridData)text.getLayoutData()).horizontalIndent = 10;
        text.setText(this.getEnvironment(proc));
        this.setTitle(DebugPreferencesMessages.ProcessPropertyPage_2);
        return parent;
    }

    private IProcess getProcess() {
        IProcess proc = null;
        IAdaptable obj = this.getElement();
        if (obj instanceof IDebugElement) {
            obj = ((IDebugElement)obj).getDebugTarget().getProcess();
        }
        if (obj instanceof IProcess) {
            proc = (IProcess)obj;
        }
        return proc;
    }

    private String getPathText(IProcess proc) {
        String text = DebugPreferencesMessages.ProcessPropertyPage_3;
        if (proc != null) {
            String tmp = proc.getAttribute("org.eclipse.debug.core.ATTR_PATH");
            if (tmp != null) {
                return tmp;
            }
            tmp = proc.getLabel();
            int idx = tmp.lastIndexOf(40);
            if (idx < 0) {
                idx = tmp.length();
            }
            text = tmp.substring(0, idx);
        }
        return text;
    }

    private String getLaunchTimeText(IProcess proc) {
        String text = this.getTimeFromAttribute(proc, "org.eclipse.debug.core.launch.timestamp");
        if (text != null) {
            return text;
        }
        Pattern pattern = Pattern.compile("\\(.*\\)");
        Matcher matcher = pattern.matcher(proc.getLabel());
        if (matcher.find()) {
            text = matcher.group(0);
        }
        if (text != null) {
            return text;
        }
        return DebugPreferencesMessages.ProcessPropertyPage_4;
    }

    private String getTerminateTimeText(IProcess proc) {
        String text = this.getTimeFromAttribute(proc, "org.eclipse.debug.core.terminate.timestamp");
        return text != null ? text : DebugPreferencesMessages.ProcessPropertyPage_4;
    }

    private String getTimeFromAttribute(IProcess proc, String attr) {
        if (proc == null || attr == null) {
            return null;
        }
        String time = proc.getAttribute(attr);
        if (time == null) {
            return null;
        }
        try {
            long l = Long.parseLong(time);
            return DateFormat.getDateTimeInstance(2, 2).format(new Date(l));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Date fdate = DateFormat.getInstance().parse(time);
                return DateFormat.getDateTimeInstance(2, 2).format(fdate);
            }
            catch (ParseException parseException) {
                return time;
            }
        }
    }

    String getEnvironment(IProcess proc) {
        String tmp;
        String env = DebugPreferencesMessages.ProcessPropertyPage_8;
        if (proc != null && (tmp = proc.getAttribute("org.eclipse.debug.core.ATTR_ENVIRONMENT")) != null) {
            return tmp;
        }
        return env;
    }

    String getWorkingDirectory(IProcess proc) {
        String tmp;
        String wd = DebugPreferencesMessages.ProcessPropertyPage_9;
        if (proc != null && (tmp = proc.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY")) != null) {
            return tmp;
        }
        return wd;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.debug.ui.process_property_page_context");
    }
}

