/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class LongEdgeJoiner
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Edge joining", 1.0f);
        boolean addUnnecessaryBendpoints = (Boolean)layeredGraph.getProperty(LayeredOptions.UNNECESSARY_BENDPOINTS);
        for (Layer layer : layeredGraph) {
            ListIterator<LNode> nodeIterator = layer.getNodes().listIterator();
            while (nodeIterator.hasNext()) {
                LNode node = nodeIterator.next();
                if (node.getType() != LNode.NodeType.LONG_EDGE) continue;
                LongEdgeJoiner.joinAt(node, addUnnecessaryBendpoints);
                nodeIterator.remove();
            }
        }
        monitor.done();
    }

    public static void joinAt(LNode longEdgeDummy, boolean addUnnecessaryBendpoints) {
        List<LEdge> inputPortEdges = longEdgeDummy.getPorts(PortSide.WEST).iterator().next().getIncomingEdges();
        List<LEdge> outputPortEdges = longEdgeDummy.getPorts(PortSide.EAST).iterator().next().getOutgoingEdges();
        int edgeCount = inputPortEdges.size();
        KVector unnecessaryBendpoint = longEdgeDummy.getPorts().get(0).getAbsoluteAnchor();
        while (edgeCount-- > 0) {
            LEdge survivingEdge = inputPortEdges.get(0);
            LEdge droppedEdge = outputPortEdges.get(0);
            List<LEdge> targetIncomingEdges = droppedEdge.getTarget().getIncomingEdges();
            int droppedEdgeListIndex = targetIncomingEdges.indexOf((Object)droppedEdge);
            survivingEdge.setTargetAndInsertAtIndex(droppedEdge.getTarget(), droppedEdgeListIndex);
            droppedEdge.setSource(null);
            droppedEdge.setTarget(null);
            KVectorChain survivingBendPoints = survivingEdge.getBendPoints();
            if (addUnnecessaryBendpoints) {
                survivingBendPoints.add((Object)new KVector(unnecessaryBendpoint));
            }
            for (KVector bendPoint : droppedEdge.getBendPoints()) {
                survivingBendPoints.add((Object)new KVector(bendPoint));
            }
            List<LLabel> survivingLabels = survivingEdge.getLabels();
            for (LLabel label : droppedEdge.getLabels()) {
                survivingLabels.add(label);
            }
            KVectorChain survivingJunctionPoints = (KVectorChain)survivingEdge.getProperty(LayeredOptions.JUNCTION_POINTS);
            KVectorChain droppedJunctionsPoints = (KVectorChain)droppedEdge.getProperty(LayeredOptions.JUNCTION_POINTS);
            if (droppedJunctionsPoints == null) continue;
            if (survivingJunctionPoints == null) {
                survivingJunctionPoints = new KVectorChain();
                survivingEdge.setProperty(LayeredOptions.JUNCTION_POINTS, survivingJunctionPoints);
            }
            for (KVector jp : droppedJunctionsPoints) {
                survivingJunctionPoints.add((Object)new KVector(jp));
            }
        }
    }
}

