/*
 * Decompiled with CFR 0.152.
 */
package activity.util;

import activity.Activity;
import activity.ActivitySet;
import activity.Claim;
import activity.Event;
import activity.RaiseEvent;
import activity.Release;
import activity.RequireEvent;
import activity.ResourceAction;
import activity.util.ActivityUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import machine.IResource;
import machine.Machine;
import machine.MachineFactory;
import machine.Resource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsat.common.graph.directed.editable.Edge;

public class Event2Resource {
    private Event2Resource() {
    }

    public static void replaceEventsWithClaimRelease(ActivitySet activitySet) {
        Event2Resource.insertClaimReleaseForEvents(activitySet, false);
    }

    public static void surroundEventsWithClaimRelease(ActivitySet activitySet) {
        Event2Resource.insertClaimReleaseForEvents(activitySet, true);
    }

    private static void insertClaimReleaseForEvents(ActivitySet activitySet, boolean keepEvents) {
        Machine machine = Event2Resource.getMachine(activitySet);
        Event2Resource.addEventsAsResource(machine, activitySet);
        Event2Resource.getEvents(activitySet).forEach(event -> {
            Resource resource = machine.getResources().stream().filter(r -> r.getName().equals(event.getEventName())).findFirst().get();
            Event2Resource.insertClaimReleaseForEvents(event, resource, keepEvents);
        });
    }

    private static void addEventsAsResource(Machine machine, ActivitySet activitySet) {
        Event2Resource.getEvents(activitySet).stream().map(Event::getEventName).distinct().forEach(event -> {
            Resource r = MachineFactory.eINSTANCE.createResource();
            r.setName(event);
            machine.getResources().add((Object)r);
        });
    }

    private static Machine getMachine(ActivitySet activitySet) {
        return activitySet.getActivities().stream().flatMap(a -> a.getNodes().stream()).filter(ResourceAction.class::isInstance).map(ResourceAction.class::cast).map(ResourceAction::getResource).map(IResource::getResource).map(EObject::eContainer).filter(Machine.class::isInstance).map(Machine.class::cast).findFirst().orElse(null);
    }

    private static Collection<Event> getEvents(ActivitySet activitySet) {
        return activitySet.getActivities().stream().flatMap(a -> a.getNodes().stream()).filter(Event.class::isInstance).map(Event.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static void insertClaimReleaseForEvents(Event node, Resource resource, boolean keepEvent) {
        boolean containsSingleEvent;
        Activity activity = (Activity)node.eContainer();
        boolean bl = containsSingleEvent = activity.getNodes().stream().filter(Event.class::isInstance).count() == 1L;
        if (containsSingleEvent || node instanceof RequireEvent) {
            Event2Resource.insertClaim(node, resource);
        }
        if (containsSingleEvent || node instanceof RaiseEvent) {
            Event2Resource.insertRelease(node, resource);
        }
        if (!keepEvent) {
            Event2Resource.shortcutAndRemoveNode(node);
        }
    }

    private static void insertClaim(Event node, Resource resource) {
        Activity activity = (Activity)node.eContainer();
        Claim cl = ActivityUtil.addClaim(activity, (IResource)resource);
        node.getIncomingEdges().forEach(e -> ActivityUtil.addEdge(activity, e.getSourceNode(), cl));
        new ArrayList<Edge>((Collection<Edge>)node.getIncomingEdges()).forEach(e -> ActivityUtil.delete(e));
        ActivityUtil.addEdge(activity, cl, node);
    }

    private static void insertRelease(Event node, Resource resource) {
        Activity activity = (Activity)node.eContainer();
        Release rl = ActivityUtil.addRelease(activity, (IResource)resource);
        node.getOutgoingEdges().forEach(e -> ActivityUtil.addEdge(activity, rl, e.getTargetNode()));
        new ArrayList<Edge>((Collection<Edge>)node.getOutgoingEdges()).forEach(e -> ActivityUtil.delete(e));
        ActivityUtil.addEdge(activity, node, rl);
    }

    private static void shortcutAndRemoveNode(Event node) {
        Activity activity = (Activity)node.eContainer();
        for (Edge in : node.getIncomingEdges()) {
            for (Edge out : node.getOutgoingEdges()) {
                ActivityUtil.addEdge(activity, in.getSourceNode(), out.getTargetNode());
            }
        }
        new ArrayList<Edge>((Collection<Edge>)node.getIncomingEdges()).forEach(e -> ActivityUtil.delete(e));
        new ArrayList<Edge>((Collection<Edge>)node.getOutgoingEdges()).forEach(e -> ActivityUtil.delete(e));
        ActivityUtil.delete(node);
    }
}

