/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.ecore.resource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

public class GZIPAwareURIConverter
implements URIConverter {
    protected static final byte[] GZIP_MAGIC = new byte[]{31, -117};
    private final URIConverter delegate;

    public GZIPAwareURIConverter() {
        this((URIConverter)new ExtensibleURIConverterImpl());
    }

    public GZIPAwareURIConverter(URIConverter delegate) {
        this.delegate = delegate;
    }

    public static InputStream tryGZIPInputStream(InputStream inputStream) throws IOException {
        if (inputStream instanceof GZIPInputStream) {
            return inputStream;
        }
        InputStream result = inputStream;
        if (!result.markSupported()) {
            result = new BufferedInputStream(result);
        }
        byte[] signature = new byte[2];
        result.mark(signature.length);
        int read = result.read(signature);
        result.reset();
        if (read == signature.length && Arrays.equals(signature, GZIP_MAGIC)) {
            result = new GZIPInputStream(result);
        }
        return result;
    }

    public URI normalize(URI uri) {
        return this.delegate.normalize(uri);
    }

    public Map<URI, URI> getURIMap() {
        return this.delegate.getURIMap();
    }

    public EList<URIHandler> getURIHandlers() {
        return this.delegate.getURIHandlers();
    }

    public URIHandler getURIHandler(URI uri) {
        return this.delegate.getURIHandler(uri);
    }

    public EList<ContentHandler> getContentHandlers() {
        return this.delegate.getContentHandlers();
    }

    public InputStream createInputStream(URI uri) throws IOException {
        return GZIPAwareURIConverter.tryGZIPInputStream(this.delegate.createInputStream(uri));
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        return GZIPAwareURIConverter.tryGZIPInputStream(this.delegate.createInputStream(uri, options));
    }

    public OutputStream createOutputStream(URI uri) throws IOException {
        return this.delegate.createOutputStream(uri);
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        return this.delegate.createOutputStream(uri, options);
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        this.delegate.delete(uri, options);
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        return this.delegate.contentDescription(uri, options);
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return this.delegate.exists(uri, options);
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        return this.delegate.getAttributes(uri, options);
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        this.delegate.setAttributes(uri, attributes, options);
    }
}

