/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.benchmarking;

import java.io.PrintWriter;
import org.eclipse.lsat.common.ludus.backend.games.benchmarking.Benchmark;
import org.eclipse.lsat.common.ludus.backend.games.benchmarking.generator.Tor;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGDoubleImplJGraphT;

public class TorDoubleBenchmark
extends Benchmark {
    private final String name;
    private final Integer sizeMin;
    private final Integer sizeMax;
    private final Integer stepSize;
    private final Double maxWeight1;
    private final Double maxWeight2;
    private PrintWriter file;

    public TorDoubleBenchmark(String name, Integer sizeMin, Integer sizeMax, Integer stepSize, Double maxWeight1, Double maxWeight2) {
        this.name = name;
        this.sizeMin = sizeMin;
        this.sizeMax = sizeMax;
        this.stepSize = stepSize;
        this.maxWeight1 = maxWeight1;
        this.maxWeight2 = maxWeight2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void run(Integer numberOfIterations, boolean runPI, boolean runEG, boolean runZP) {
        this.file = this.getFile(this.name);
        this.file.printf("%s,%s,%s,%s,%s,%s\n", "N", "maxWeight1", "maxWeight2", "PolicyIteration", "EnergyGame", "ZwickPaterson");
        System.out.printf("%s,%s,%s,%s,%s,%s\n", "N", "maxWeight1", "maxWeight2", "PolicyIteration", "EnergyGame", "ZwickPaterson");
        int runId = 0;
        while (runId < numberOfIterations) {
            int v = this.sizeMin;
            while (v <= this.sizeMax) {
                this.runAlgorithmsTor(v, this.maxWeight1, this.maxWeight2, runPI, runEG, runZP);
                v += this.stepSize.intValue();
            }
            ++runId;
        }
        this.file.close();
    }

    private void runAlgorithmsTor(Integer size, Double maxWeight1, Double maxWeight2, boolean runPI, boolean runEG, boolean runZP) {
        RGDoubleImplJGraphT torGraph = Tor.generateRatioGame(size, maxWeight1, maxWeight2);
        float piSec = 0.0f;
        if (runPI) {
            long piResult = this.runPI(torGraph);
            piSec = (float)piResult / 1.0E9f;
        }
        float egSec = 0.0f;
        if (runEG) {
            long egResult = this.runEG(torGraph);
            egSec = (float)egResult / 1.0E9f;
        }
        float zpSec = 0.0f;
        if (runZP) {
            long zpResult = this.runZP(torGraph);
            zpSec = (float)zpResult / 1.0E9f;
        }
        this.file.printf("%d,%f,%f,%f,%f,%f\n", size, maxWeight1, maxWeight2, Float.valueOf(piSec), Float.valueOf(egSec), Float.valueOf(zpSec));
        System.out.printf("%d,%f,%f,%f,%f,%f\n", size, maxWeight1, maxWeight2, Float.valueOf(piSec), Float.valueOf(egSec), Float.valueOf(zpSec));
    }
}

