/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.apache.batik.transcoder.TranscoderException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.AbstractPoly;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.GdiBrush;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.GdiPen;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IRenderToPath;

public class Polygon
extends AbstractPoly
implements IRenderToPath {
    public Polygon(boolean b16Bits) {
        super(b16Bits);
    }

    @Override
    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        GdiPen curPen;
        GdiBrush brush = context.getCurBrush();
        Shape s = this.getShape(context);
        if (brush != null) {
            brush.fill(s, g, context);
        }
        if ((curPen = context.getCurPen()) != null) {
            curPen.apply(g, context);
            g.draw(s);
        }
    }

    @Override
    public void render(DeviceContext context) throws TranscoderException {
        Shape s = this.getShape(context);
        context.getGdiPath().appendFigure(s);
    }

    private Shape getShape(DeviceContext context) {
        GeneralPath p = new GeneralPath();
        int count = this.getCount();
        if (count > 0) {
            this.m_xPointsConv = context.convertXArrayToSVGLogicalUnits(this.getXPoints());
            this.m_yPointsConv = context.convertYArrayToSVGLogicalUnits(this.getYPoints());
            p.moveTo(this.m_xPointsConv[0], this.m_yPointsConv[0]);
            int index = 1;
            while (index < count) {
                p.lineTo(this.m_xPointsConv[index], this.m_yPointsConv[index]);
                ++index;
            }
            p.closePath();
        }
        return p;
    }
}

