/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.marker;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.SeriesLabelProvider;
import org.eclipse.swtchart.extensions.marker.AbstractBaseChartPaintListener;
import org.eclipse.swtchart.extensions.marker.IBaseChartPaintListener;

public class EmbeddedLegend
extends AbstractBaseChartPaintListener
implements IBaseChartPaintListener {
    private int x = 0;
    private int y = 0;

    public EmbeddedLegend(BaseChart baseChart) {
        super(baseChart);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void paintControl(PaintEvent e) {
        if (this.isDraw()) {
            GC gc = e.gc;
            int lineStyle = gc.getLineStyle();
            Color colorForeground = gc.getForeground();
            BaseChart baseChart = this.getBaseChart();
            ISeriesSet seriesSet = baseChart.getSeriesSet();
            int x0 = this.x;
            int y0 = this.y;
            ISeries[] iSeriesArray = seriesSet.getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries series = iSeriesArray[n2];
                if (series.isVisible() && series.isVisibleInLegend()) {
                    ISeriesSettings seriesSettings = baseChart.getSeriesSettings(series.getId());
                    String description = seriesSettings.getDescription();
                    Color color = SeriesLabelProvider.getColor(seriesSettings);
                    if (color != null) {
                        gc.setForeground(color);
                        gc.drawText(description, x0, y0);
                        y0 += 20;
                    }
                }
                ++n2;
            }
            gc.setLineStyle(lineStyle);
            gc.setForeground(colorForeground);
        }
    }
}

