/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.core;

import org.mandas.docker.client.exceptions.DockerRequestException;

public class DockerException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final String JSON_MESSAGE_PREFIX = "{\"message\":\"";
    private static final String JSON_MESSAGE_SUFFIX = "\"}";

    public DockerException(String message) {
        super(message);
    }

    public DockerException(String message, Throwable cause) {
        super(DockerException.calculateMessage(message, cause), cause);
    }

    public DockerException(Throwable cause) {
        super(DockerException.calculateMessage(null, cause), cause);
    }

    private static String calculateMessage(String message, Throwable cause) {
        DockerRequestException re;
        String s;
        Throwable dre;
        for (dre = cause; dre != null && !(dre instanceof DockerRequestException); dre = dre.getCause()) {
        }
        if (dre != null && (s = (re = (DockerRequestException)dre).getResponseBody()) != null && s.startsWith(JSON_MESSAGE_PREFIX)) {
            s = s.substring(JSON_MESSAGE_PREFIX.length());
            s = s.replaceAll(JSON_MESSAGE_SUFFIX, "");
            if (message != null) {
                return message + "; " + s;
            }
            return s;
        }
        if (message == null && cause != null) {
            return cause.toString();
        }
        return message;
    }
}

