/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.menu.legend;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.SeriesListUI;
import org.eclipse.swtchart.extensions.core.SeriesMapper;
import org.eclipse.swtchart.extensions.menu.legend.AbstractMenuListener;
import org.eclipse.swtchart.extensions.menu.legend.Messages;

public class MapSettingsAction
extends AbstractMenuListener {
    private boolean addMapping = true;

    public MapSettingsAction(SeriesListUI seriesListUI, boolean addMapping) {
        super(seriesListUI);
        this.addMapping = addMapping;
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)new Action(){

            public String getText() {
                return MapSettingsAction.this.addMapping ? Messages.getString("ADD_SERIES_MAPPING") : Messages.getString("REMOVE_SERIES_MAPPING");
            }

            public String getToolTipText() {
                return Messages.getString("ADD_REMOVE_SERIES_MAPPING");
            }

            public void run() {
                BaseChart baseChart = MapSettingsAction.this.getBaseChart();
                List<ISeries<?>> selectedSeries = MapSettingsAction.this.getSelectedSeries();
                for (ISeries<?> series : selectedSeries) {
                    if (MapSettingsAction.this.addMapping) {
                        SeriesMapper.map(series, baseChart);
                        continue;
                    }
                    SeriesMapper.unmap(series, baseChart);
                }
                MapSettingsAction.this.refresh();
            }
        });
    }
}

