/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import org.eclipse.equinox.metatype.impl.AttributeDefinitionImpl;
import org.eclipse.equinox.metatype.impl.Designate;
import org.eclipse.equinox.metatype.impl.Icon;
import org.eclipse.equinox.metatype.impl.MetaTypeMsg;
import org.eclipse.equinox.metatype.impl.ObjectClassDefinitionImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataParser {
    private static final String METADATA = "MetaData";
    private static final String LOCALIZATION = "localization";
    private static final String OCD = "OCD";
    private static final String ICON = "Icon";
    private static final String AD = "AD";
    private static final String CARDINALITY = "cardinality";
    private static final String OPTION = "Option";
    private static final String LABEL = "label";
    private static final String VALUE = "value";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String TYPE = "type";
    private static final String SIZE = "size";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String RESOURCE = "resource";
    private static final String PID = "pid";
    private static final String DEFAULT = "default";
    private static final String ADREF = "adref";
    private static final String CONTENT = "content";
    private static final String FACTORY = "factoryPid";
    private static final String BUNDLE = "bundle";
    private static final String OPTIONAL = "optional";
    private static final String OBJECT = "Object";
    private static final String OCDREF = "ocdref";
    private static final String ATTRIBUTE = "Attribute";
    private static final String DESIGNATE = "Designate";
    private static final String MERGE = "merge";
    private static final String REQUIRED = "required";
    private static final String INTEGER = "Integer";
    private static final String STRING = "String";
    private static final String FLOAT = "Float";
    private static final String DOUBLE = "Double";
    private static final String BYTE = "Byte";
    private static final String LONG = "Long";
    private static final String CHAR = "Char";
    private static final String BOOLEAN = "Boolean";
    private static final String SHORT = "Short";
    private static final String PASSWORD = "Password";
    protected Bundle _dp_bundle;
    protected URL _dp_url;
    protected SAXParser _dp_parser;
    protected XMLReader _dp_xmlReader;
    Vector<DesignateHandler> _dp_designateHandlers = new Vector(7);
    Hashtable<String, ObjectClassDefinitionImpl> _dp_OCDs = new Hashtable(7);
    String _dp_localization;
    final LogService logger;
    final Collection<Designate> designates = new ArrayList<Designate>(7);

    public DataParser(Bundle bundle, URL url, SAXParser parser, LogService logger) {
        this._dp_bundle = bundle;
        this._dp_url = url;
        this._dp_parser = parser;
        this.logger = logger;
    }

    public Collection<Designate> doParse() throws IOException, SAXException {
        this._dp_xmlReader = this._dp_parser.getXMLReader();
        this._dp_xmlReader.setContentHandler(new RootHandler());
        this._dp_xmlReader.setErrorHandler(new MyErrorHandler(System.err));
        InputStream is = this._dp_url.openStream();
        InputSource isource = new InputSource(is);
        this.logger.log(4, new StringBuffer("Starting to parse ").append(this._dp_url).toString());
        this._dp_xmlReader.parse(isource);
        return this.designates;
    }

    static Object convert(String value, int type) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case 1: 
            case 12: {
                return new Integer(value);
            }
            case 2: {
                return new Long(value);
            }
            case 3: {
                return new Integer(value);
            }
            case 4: {
                return new Short(value);
            }
            case 5: {
                return new Character(value.charAt(0));
            }
            case 6: {
                return new Byte(value);
            }
            case 7: {
                return new Double(value);
            }
            case 8: {
                return new Float(value);
            }
            case 9: {
                return new BigInteger(value);
            }
            case 10: {
                return new BigDecimal(value);
            }
            case 11: {
                return new Boolean(value);
            }
        }
        return null;
    }

    public static String getName(String localName, String qName) {
        if (localName != null && localName.length() > 0) {
            return localName;
        }
        int nameSpaceIndex = qName.indexOf(":");
        return nameSpaceIndex == -1 ? qName : qName.substring(nameSpaceIndex + 1);
    }

    private class AbstractHandler
    extends DefaultHandler {
        protected ContentHandler _doc_handler;
        protected boolean _isParsedDataValid = true;
        protected Map<String, Map<String, String>> extensionAttributes = new HashMap<String, Map<String, String>>();

        public AbstractHandler(ContentHandler parentHandler) {
            this._doc_handler = parentHandler;
            DataParser.this._dp_xmlReader.setContentHandler(this);
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            this.finished();
            DataParser.this._dp_xmlReader.setContentHandler(this._doc_handler);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            throw new SAXException(NLS.bind((String)MetaTypeMsg.UNEXPECTED_ELEMENT, (Object)qName));
        }

        public void characters(char[] buf, int start, int end) throws SAXException {
            String s = new String(buf, start, end).trim();
            if (s.length() > 0) {
                throw new SAXException(NLS.bind((String)MetaTypeMsg.UNEXPECTED_TEXT, (Object)s));
            }
        }

        protected void collectExtensionAttributes(Attributes attributes) {
            int i = 0;
            while (i < attributes.getLength()) {
                String key = attributes.getURI(i);
                if (key.length() != 0 && !key.startsWith("http://www.osgi.org/xmlns/metatype/v")) {
                    Map<String, String> value = this.extensionAttributes.get(key);
                    if (value == null) {
                        value = new HashMap<String, String>();
                        this.extensionAttributes.put(key, value);
                    }
                    value.put(DataParser.getName(attributes.getLocalName(i), attributes.getQName(i)), attributes.getValue(i));
                }
                ++i;
            }
        }

        protected void finished() {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AttributeDefinitionHandler
    extends AbstractHandler {
        AttributeDefinitionImpl _ad;
        int _dataType;
        Vector<AttributeDefinitionImpl> _parent_ADs_vector;
        Vector<String> _optionLabel_vector;
        Vector<String> _optionValue_vector;

        public AttributeDefinitionHandler(ContentHandler handler) {
            super(handler);
            this._optionLabel_vector = new Vector(7);
            this._optionValue_vector = new Vector(7);
        }

        public void init(String name, Attributes atts, Vector<AttributeDefinitionImpl> ad_vector) {
            DataParser.this.logger.log(4, "Here is AttributeDefinitionHandler():init()");
            this._parent_ADs_vector = ad_vector;
            this.collectExtensionAttributes(atts);
            String ad_name_val = atts.getValue(DataParser.NAME);
            String ad_description_val = atts.getValue(DataParser.DESCRIPTION);
            String ad_id_val = atts.getValue(DataParser.ID);
            if (ad_id_val == null) {
                this._isParsedDataValid = false;
                DataParser.this.logger.log(1, new StringBuffer("DataParser.init(String, Attributes, Vector) ").append(NLS.bind((String)MetaTypeMsg.MISSING_ATTRIBUTE, (Object)DataParser.ID, (Object)name)).toString());
                return;
            }
            String ad_type_val = atts.getValue(DataParser.TYPE);
            if (ad_type_val == null) {
                this._isParsedDataValid = false;
                DataParser.this.logger.log(1, new StringBuffer("DataParser.init(String, Attributes, Vector) ").append(NLS.bind((String)MetaTypeMsg.MISSING_ATTRIBUTE, (Object)DataParser.TYPE, (Object)name)).toString());
                return;
            }
            if (ad_type_val.equalsIgnoreCase(DataParser.STRING)) {
                this._dataType = 1;
            } else if (ad_type_val.equalsIgnoreCase(DataParser.LONG)) {
                this._dataType = 2;
            } else if (ad_type_val.equalsIgnoreCase(DataParser.DOUBLE)) {
                this._dataType = 7;
            } else if (ad_type_val.equalsIgnoreCase(DataParser.FLOAT)) {
                this._dataType = 8;
            } else if (ad_type_val.equalsIgnoreCase(DataParser.INTEGER)) {
                this._dataType = 3;
            } else if (ad_type_val.equalsIgnoreCase(DataParser.BYTE)) {
                this._dataType = 6;
            } else if (ad_type_val.equalsIgnoreCase(DataParser.CHAR)) {
                this._dataType = 5;
            } else if (ad_type_val.equalsIgnoreCase(DataParser.BOOLEAN)) {
                this._dataType = 11;
            } else if (ad_type_val.equalsIgnoreCase(DataParser.SHORT)) {
                this._dataType = 4;
            } else if (ad_type_val.equalsIgnoreCase(DataParser.PASSWORD)) {
                this._dataType = 12;
            } else {
                this._isParsedDataValid = false;
                Object[] objectArray = new Object[3];
                objectArray[0] = ad_type_val;
                objectArray[1] = DataParser.this._dp_url;
                objectArray[2] = new Long(DataParser.this._dp_bundle.getBundleId());
                DataParser.this.logger.log(1, new StringBuffer("DataParser.init(String, Attributes, Vector) ").append(NLS.bind((String)MetaTypeMsg.INVALID_TYPE, (Object[])objectArray)).toString());
                return;
            }
            String ad_cardinality_str = atts.getValue(DataParser.CARDINALITY);
            int ad_cardinality_val = 0;
            if (ad_cardinality_str != null) {
                ad_cardinality_val = Integer.parseInt(ad_cardinality_str);
            }
            String ad_min_val = atts.getValue(DataParser.MIN);
            String ad_max_val = atts.getValue(DataParser.MAX);
            String ad_defaults_str = atts.getValue(DataParser.DEFAULT);
            String ad_required_val = atts.getValue(DataParser.REQUIRED);
            if (ad_required_val == null) {
                ad_required_val = Boolean.TRUE.toString();
            }
            this._ad = new AttributeDefinitionImpl(ad_id_val, ad_name_val, ad_description_val, this._dataType, ad_cardinality_val, DataParser.convert(ad_min_val, this._dataType), DataParser.convert(ad_max_val, this._dataType), (boolean)Boolean.valueOf(ad_required_val), DataParser.this._dp_localization, DataParser.this.logger, this.extensionAttributes);
            if (ad_defaults_str != null) {
                this._ad.setDefaultValue(ad_defaults_str, true);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            DataParser.this.logger.log(4, new StringBuffer("Here is AttributeDefinitionHandler:startElement():").append(qName).toString());
            if (!this._isParsedDataValid) {
                return;
            }
            String name = DataParser.getName(localName, qName);
            if (name.equalsIgnoreCase(DataParser.OPTION)) {
                OptionHandler optionHandler = new OptionHandler(this);
                optionHandler.init(name, atts);
                if (optionHandler._isParsedDataValid) {
                    this._optionLabel_vector.addElement(optionHandler._label_val);
                    this._optionValue_vector.addElement(optionHandler._value_val);
                }
            } else {
                DataParser.this.logger.log(2, NLS.bind((String)MetaTypeMsg.UNEXPECTED_ELEMENT, (Object)name));
            }
        }

        @Override
        protected void finished() {
            DataParser.this.logger.log(4, "Here is AttributeDefinitionHandler():finished()");
            if (!this._isParsedDataValid) {
                return;
            }
            this._ad.setOption(this._optionLabel_vector, this._optionValue_vector, true);
            this._parent_ADs_vector.addElement(this._ad);
        }
    }

    private class AttributeHandler
    extends AbstractHandler {
        String _adref_val;
        String _content_val;

        public AttributeHandler(ContentHandler handler) {
            super(handler);
        }

        public void init(String name, Attributes atts) {
            DataParser.this.logger.log(4, "Here is AttributeHandler():init()");
            this._adref_val = atts.getValue(DataParser.ADREF);
            if (this._adref_val == null) {
                this._isParsedDataValid = false;
                DataParser.this.logger.log(1, "DataParser.init(String, Attributes) " + NLS.bind((String)MetaTypeMsg.MISSING_ATTRIBUTE, (Object)DataParser.ADREF, (Object)name));
                return;
            }
            this._content_val = atts.getValue(DataParser.CONTENT);
            if (this._content_val == null) {
                this._isParsedDataValid = false;
                DataParser.this.logger.log(1, "DataParser.init(String, Attributes) " + NLS.bind((String)MetaTypeMsg.MISSING_ATTRIBUTE, (Object)DataParser.CONTENT, (Object)name));
                return;
            }
        }
    }

    class DesignateHandler
    extends AbstractHandler {
        String _pid_val;
        String _factory_val;
        String _bundle_val;
        boolean _optional_val;
        boolean _merge_val;
        String _ocdref;

        public DesignateHandler(ContentHandler handler) {
            super(handler);
            this._pid_val = null;
            this._factory_val = null;
            this._bundle_val = null;
            this._optional_val = false;
            this._merge_val = false;
        }

        public void init(String name, Attributes atts) {
            DataParser.this.logger.log(4, "Here is DesignateHandler():init()");
            this._pid_val = atts.getValue(DataParser.PID);
            this._factory_val = atts.getValue(DataParser.FACTORY);
            if (this._pid_val == null && this._factory_val == null) {
                this._isParsedDataValid = false;
                DataParser.this.logger.log(1, MetaTypeMsg.MISSING_DESIGNATE_PID_AND_FACTORYPID);
                return;
            }
            this._bundle_val = atts.getValue(DataParser.BUNDLE);
            String optional_str = atts.getValue(DataParser.OPTIONAL);
            this._optional_val = optional_str == null ? false : Boolean.valueOf(optional_str);
            String merge_str = atts.getValue(DataParser.MERGE);
            this._merge_val = merge_str == null ? false : Boolean.valueOf(merge_str);
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) {
            DataParser.this.logger.log(4, "Here is DesignateHandler:startElement():" + qName);
            if (!this._isParsedDataValid) {
                return;
            }
            String name = DataParser.getName(localName, qName);
            if (name.equalsIgnoreCase(DataParser.OBJECT)) {
                ObjectHandler objectHandler = new ObjectHandler(this);
                objectHandler.init(name, atts);
                if (objectHandler._isParsedDataValid) {
                    this._ocdref = objectHandler._ocdref;
                }
            } else {
                DataParser.this.logger.log(2, NLS.bind((String)MetaTypeMsg.UNEXPECTED_ELEMENT, (Object)name));
            }
        }

        protected void finished() {
            DataParser.this.logger.log(4, "Here is DesignateHandler():finished()");
            if (!this._isParsedDataValid) {
                return;
            }
            if (this._ocdref == null) {
                this._isParsedDataValid = false;
                DataParser.this.logger.log(1, "DataParser.finished() " + NLS.bind((String)MetaTypeMsg.MISSING_ELEMENT, (Object)DataParser.OBJECT, (Object)this._pid_val));
                return;
            }
        }
    }

    private class IconHandler
    extends AbstractHandler {
        Icon _icon;

        public IconHandler(ContentHandler handler) {
            super(handler);
        }

        public void init(String name, Attributes atts) {
            DataParser.this.logger.log(4, "Here is IconHandler:init()");
            String icon_resource_val = atts.getValue(DataParser.RESOURCE);
            if (icon_resource_val == null) {
                this._isParsedDataValid = false;
                DataParser.this.logger.log(1, "DataParser.init(String, Attributes) " + NLS.bind((String)MetaTypeMsg.MISSING_ATTRIBUTE, (Object)DataParser.RESOURCE, (Object)name));
                return;
            }
            String icon_size_val = atts.getValue(DataParser.SIZE);
            if (icon_size_val == null) {
                icon_size_val = "0";
            } else if (icon_size_val.equalsIgnoreCase("")) {
                icon_size_val = "0";
            }
            this._icon = new Icon(icon_resource_val, new Integer(Integer.parseInt(icon_size_val)), DataParser.this._dp_bundle);
        }
    }

    private class MetaDataHandler
    extends AbstractHandler {
        public MetaDataHandler(ContentHandler handler) {
            super(handler);
        }

        public void init(String name, Attributes attributes) {
            DataParser.this.logger.log(4, "Here is MetaDataHandler():init()");
            DataParser.this._dp_localization = attributes.getValue(DataParser.LOCALIZATION);
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) {
            DataParser.this.logger.log(4, "Here is MetaDataHandler:startElement():" + qName);
            String name = DataParser.getName(localName, qName);
            if (name.equalsIgnoreCase(DataParser.DESIGNATE)) {
                DesignateHandler designateHandler = new DesignateHandler(this);
                designateHandler.init(name, atts);
                if (designateHandler._isParsedDataValid) {
                    DataParser.this._dp_designateHandlers.addElement(designateHandler);
                }
            } else if (name.equalsIgnoreCase(DataParser.OCD)) {
                OcdHandler ocdHandler = new OcdHandler(this);
                ocdHandler.init(name, atts, DataParser.this._dp_OCDs);
            } else {
                DataParser.this.logger.log(2, NLS.bind((String)MetaTypeMsg.UNEXPECTED_ELEMENT, (Object)name));
            }
        }

        protected void finished() {
            DataParser.this.logger.log(4, "Here is MetaDataHandler():finished()");
            if (DataParser.this._dp_designateHandlers.size() == 0) {
                this._isParsedDataValid = false;
                DataParser.this.logger.log(2, "DataParser.finished() " + NLS.bind((String)MetaTypeMsg.MISSING_ELEMENT, (Object)DataParser.DESIGNATE));
                return;
            }
            Enumeration<DesignateHandler> designateHandlerKeys = DataParser.this._dp_designateHandlers.elements();
            while (designateHandlerKeys.hasMoreElements()) {
                DesignateHandler dh = designateHandlerKeys.nextElement();
                ObjectClassDefinitionImpl ocd = DataParser.this._dp_OCDs.get(dh._ocdref);
                if (ocd != null) {
                    DataParser.this.designates.add(new Designate.Builder(ocd).bundle(dh._bundle_val).factoryPid(dh._factory_val).merge(dh._merge_val).pid(dh._pid_val).optional(dh._optional_val).build());
                    continue;
                }
                DataParser.this.logger.log(1, "DataParser.finished() " + NLS.bind((String)MetaTypeMsg.OCD_ID_NOT_FOUND, (Object)dh._ocdref));
            }
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private PrintStream _out;

        MyErrorHandler(PrintStream out) {
            this._out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) {
            this._out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }

    private class ObjectHandler
    extends AbstractHandler {
        String _ocdref;

        public ObjectHandler(ContentHandler handler) {
            super(handler);
        }

        public void init(String name, Attributes atts) {
            DataParser.this.logger.log(4, "Here is ObjectHandler():init()");
            this._ocdref = atts.getValue(DataParser.OCDREF);
            if (this._ocdref == null) {
                this._isParsedDataValid = false;
                DataParser.this.logger.log(1, "DataParser.init(String, Attributes) " + NLS.bind((String)MetaTypeMsg.MISSING_ATTRIBUTE, (Object)DataParser.OCDREF, (Object)name));
                return;
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) {
            DataParser.this.logger.log(4, "Here is ObjectHandler:startElement():" + qName);
            if (!this._isParsedDataValid) {
                return;
            }
            String name = DataParser.getName(localName, qName);
            if (name.equalsIgnoreCase(DataParser.ATTRIBUTE)) {
                AttributeHandler attributeHandler = new AttributeHandler(this);
                attributeHandler.init(name, atts);
            } else {
                DataParser.this.logger.log(2, NLS.bind((String)MetaTypeMsg.UNEXPECTED_ELEMENT, (Object)name));
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OcdHandler
    extends AbstractHandler {
        Hashtable<String, ObjectClassDefinitionImpl> _parent_OCDs_hashtable;
        String _refID;
        ObjectClassDefinitionImpl _ocd;
        Vector<AttributeDefinitionImpl> _ad_vector;
        List<Icon> icons;

        public OcdHandler(ContentHandler handler) {
            super(handler);
            this._ad_vector = new Vector(7);
            this.icons = new ArrayList<Icon>(5);
        }

        public void init(String name, Attributes atts, Hashtable<String, ObjectClassDefinitionImpl> ocds_hashtable) {
            DataParser.this.logger.log(4, "Here is OcdHandler():init()");
            this._parent_OCDs_hashtable = ocds_hashtable;
            this.collectExtensionAttributes(atts);
            String ocd_name_val = atts.getValue(DataParser.NAME);
            if (ocd_name_val == null) {
                this._isParsedDataValid = false;
                DataParser.this.logger.log(1, new StringBuffer("DataParser.init(String, Attributes, Hashtable) ").append(NLS.bind((String)MetaTypeMsg.MISSING_ATTRIBUTE, (Object)DataParser.NAME, (Object)name)).toString());
                return;
            }
            String ocd_description_val = atts.getValue(DataParser.DESCRIPTION);
            this._refID = atts.getValue(DataParser.ID);
            if (this._refID == null) {
                this._isParsedDataValid = false;
                DataParser.this.logger.log(1, new StringBuffer("DataParser.init(String, Attributes, Hashtable) ").append(NLS.bind((String)MetaTypeMsg.MISSING_ATTRIBUTE, (Object)DataParser.ID, (Object)name)).toString());
                return;
            }
            this._ocd = new ObjectClassDefinitionImpl(ocd_name_val, ocd_description_val, this._refID, DataParser.this._dp_localization, this.extensionAttributes);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            DataParser.this.logger.log(4, new StringBuffer("Here is OcdHandler:startElement():").append(qName).toString());
            if (!this._isParsedDataValid) {
                return;
            }
            String name = DataParser.getName(localName, qName);
            if (name.equalsIgnoreCase(DataParser.AD)) {
                AttributeDefinitionHandler attributeDefHandler = new AttributeDefinitionHandler(this);
                attributeDefHandler.init(name, atts, this._ad_vector);
            } else if (name.equalsIgnoreCase(DataParser.ICON)) {
                IconHandler iconHandler = new IconHandler(this);
                iconHandler.init(name, atts);
                if (iconHandler._isParsedDataValid) {
                    this.icons.add(iconHandler._icon);
                }
            } else {
                DataParser.this.logger.log(2, NLS.bind((String)MetaTypeMsg.UNEXPECTED_ELEMENT, (Object)name));
            }
        }

        @Override
        protected void finished() {
            DataParser.this.logger.log(4, "Here is OcdHandler():finished()");
            if (!this._isParsedDataValid) {
                return;
            }
            if (this._ad_vector.size() == 0) {
                this._isParsedDataValid = false;
                DataParser.this.logger.log(1, new StringBuffer("DataParser.finished() ").append(NLS.bind((String)MetaTypeMsg.MISSING_ELEMENT, (Object)DataParser.AD, (Object)this._refID)).toString());
                return;
            }
            Enumeration<AttributeDefinitionImpl> adKey = this._ad_vector.elements();
            while (adKey.hasMoreElements()) {
                AttributeDefinitionImpl ad = adKey.nextElement();
                this._ocd.addAttributeDefinition(ad, ad._isRequired);
            }
            this._ocd.setIcons(this.icons);
            this._parent_OCDs_hashtable.put(this._refID, this._ocd);
        }
    }

    private class OptionHandler
    extends AbstractHandler {
        String _label_val;
        String _value_val;

        public OptionHandler(ContentHandler handler) {
            super(handler);
        }

        public void init(String name, Attributes atts) {
            DataParser.this.logger.log(4, "Here is OptionHandler:init()");
            this._label_val = atts.getValue(DataParser.LABEL);
            if (this._label_val == null) {
                this._isParsedDataValid = false;
                DataParser.this.logger.log(1, "DataParser.init(String, Attributes) " + NLS.bind((String)MetaTypeMsg.MISSING_ATTRIBUTE, (Object)DataParser.LABEL, (Object)name));
                return;
            }
            this._value_val = atts.getValue(DataParser.VALUE);
            if (this._value_val == null) {
                this._isParsedDataValid = false;
                DataParser.this.logger.log(1, "DataParser.init(String, Attributes) " + NLS.bind((String)MetaTypeMsg.MISSING_ATTRIBUTE, (Object)DataParser.VALUE, (Object)name));
                return;
            }
        }
    }

    private class RootHandler
    extends DefaultHandler {
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            DataParser.this.logger.log(4, "Here is AbstractHandler:startElement():" + qName);
            String name = DataParser.getName(localName, qName);
            if (name.equalsIgnoreCase(DataParser.METADATA)) {
                new MetaDataHandler(this).init(name, attributes);
            } else {
                DataParser.this.logger.log(2, NLS.bind((String)MetaTypeMsg.UNEXPECTED_ELEMENT, (Object)name));
            }
        }

        public void setDocumentLocator(Locator locator) {
        }
    }
}

