/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.dockerfile.simple;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.build.api.helper.DockerFileUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;

public class SimpleDockerfileUtil {
    private SimpleDockerfileUtil() {
    }

    public static boolean isSimpleDockerFileMode(File projectBaseDirectory) {
        if (projectBaseDirectory != null) {
            return SimpleDockerfileUtil.getTopLevelDockerfile(projectBaseDirectory).exists();
        }
        return false;
    }

    public static File getTopLevelDockerfile(File projectBaseDirectory) {
        return new File(projectBaseDirectory, "Dockerfile");
    }

    public static ImageConfiguration createSimpleDockerfileConfig(File dockerFile, String defaultImageName) {
        if (defaultImageName == null) {
            defaultImageName = "%g/%a:%l";
        }
        BuildConfiguration buildConfig = BuildConfiguration.builder().dockerFile(dockerFile.getPath()).ports(SimpleDockerfileUtil.extractPorts(dockerFile)).build();
        return ImageConfiguration.builder().name(defaultImageName).build(buildConfig).build();
    }

    public static ImageConfiguration addSimpleDockerfileConfig(ImageConfiguration image, File dockerfile) {
        BuildConfiguration buildConfig = BuildConfiguration.builder().dockerFile(dockerfile.getPath()).ports(SimpleDockerfileUtil.extractPorts(dockerfile)).build();
        return image.toBuilder().build(buildConfig).build();
    }

    static List<String> extractPorts(File dockerFile) {
        Properties properties = new Properties();
        try {
            return SimpleDockerfileUtil.extractPorts(DockerFileUtil.extractLines((File)dockerFile, (String)"EXPOSE", (Properties)properties, null));
        }
        catch (IOException ioException) {
            throw new IllegalArgumentException("Error in reading Dockerfile", ioException);
        }
    }

    static List<String> extractPorts(List<String[]> dockerLinesContainingExpose) {
        HashSet ports = new HashSet();
        dockerLinesContainingExpose.forEach(line -> Arrays.stream(line).skip(1L).filter(Objects::nonNull).filter(StringUtils::isNotBlank).forEach(ports::add));
        return new ArrayList<String>(ports);
    }
}

