/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.access.hc.win;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jkube.kit.build.service.docker.access.hc.win.NpipeSocketAddress;
import org.eclipse.jkube.kit.common.KitLogger;

final class NamedPipe
extends Socket {
    private static final CharsetEncoder ASCII_ENCODER = StandardCharsets.US_ASCII.newEncoder();
    private final KitLogger log;
    private final AtomicReference<SocketAddress> socketAddress;
    private final Object connectLock = new Object();
    private volatile boolean inputShutdown;
    private volatile boolean outputShutdown;
    private String socketPath;
    private RandomAccessFile randomAccessFile;
    private FileChannel channel;

    NamedPipe(KitLogger log) {
        this.log = log;
        this.socketAddress = new AtomicReference();
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout may not be negative: " + timeout);
        }
        if (!(endpoint instanceof NpipeSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type: " + endpoint.getClass().getName());
        }
        this.socketAddress.set(endpoint);
        this.socketPath = ((NpipeSocketAddress)endpoint).getPath();
        Object object = this.connectLock;
        synchronized (object) {
            this.randomAccessFile = new RandomAccessFile(this.socketPath, "rw");
            this.channel = this.randomAccessFile.getChannel();
        }
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        throw new SocketException("Bind is not supported");
    }

    @Override
    public InetAddress getInetAddress() {
        return null;
    }

    @Override
    public InetAddress getLocalAddress() {
        return null;
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public int getLocalPort() {
        return -1;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.socketAddress.get();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return null;
    }

    @Override
    public SocketChannel getChannel() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (this.inputShutdown) {
            throw new SocketException("Socket input is shutdown");
        }
        return new FilterInputStream(Channels.newInputStream(this.channel)){

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int readed = super.read(b, off, len);
                NamedPipe.this.log.debug("RESPONSE %s", new Object[]{new String(b, off, len, StandardCharsets.UTF_8)});
                return readed;
            }

            @Override
            public void close() throws IOException {
                NamedPipe.this.shutdownInput();
            }
        };
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (this.outputShutdown) {
            throw new SocketException("Socket output is shutdown");
        }
        return new FilterOutputStream(Channels.newOutputStream(this.channel)){

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (NamedPipe.this.log.isDebugEnabled()) {
                    String request = new String(b, off, len, StandardCharsets.UTF_8);
                    String logValue = NamedPipe.this.isAscii(request) ? request : "not logged due to non-ASCII characters. ";
                    NamedPipe.this.log.debug("REQUEST %s", new Object[]{logValue});
                }
                this.out.write(b, off, len);
            }

            @Override
            public void close() throws IOException {
                NamedPipe.this.shutdownOutput();
            }
        };
    }

    private boolean isAscii(String toCheck) {
        return ASCII_ENCODER.canEncode(toCheck);
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        throw new SocketException("Urgent data not supported");
    }

    @Override
    public synchronized void setSoTimeout(int soTimeout) {
    }

    @Override
    public synchronized int getSoTimeout() {
        return 0;
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("Send buffer size must be positive: " + size);
        }
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        throw new UnsupportedOperationException("Getting the send buffer size is not supported");
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("Receive buffer size must be positive: " + size);
        }
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        throw new UnsupportedOperationException("Getting the receive buffer size is not supported");
    }

    @Override
    public synchronized void setKeepAlive(boolean keepAlive) {
    }

    @Override
    public synchronized boolean getKeepAlive() {
        return true;
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        if (tc < 0 || tc > 255) {
            throw new IllegalArgumentException("Traffic class is not in range 0 -- 255: " + tc);
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
    }

    @Override
    public int getTrafficClass() {
        throw new UnsupportedOperationException("Getting the traffic class is not supported");
    }

    @Override
    public void setReuseAddress(boolean on) {
    }

    @Override
    public boolean getReuseAddress() {
        throw new UnsupportedOperationException("Getting the SO_REUSEADDR option is not supported");
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
        }
        this.inputShutdown = true;
        this.outputShutdown = true;
    }

    @Override
    public void shutdownInput() {
        this.inputShutdown = true;
    }

    @Override
    public void shutdownOutput() {
        this.outputShutdown = true;
    }

    @Override
    public String toString() {
        if (this.isConnected()) {
            return "NamedPipe[addr=" + this.socketPath + ']';
        }
        return "NamedPipe[unconnected]";
    }

    @Override
    public boolean isConnected() {
        return !this.isClosed();
    }

    @Override
    public boolean isBound() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.channel != null && !this.channel.isOpen();
    }

    @Override
    public boolean isInputShutdown() {
        return this.inputShutdown;
    }

    @Override
    public boolean isOutputShutdown() {
        return this.outputShutdown;
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }
}

