/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.access.chunked;

import com.google.gson.JsonObject;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccessException;
import org.eclipse.jkube.kit.build.service.docker.access.chunked.EntityStreamReaderUtil;
import org.eclipse.jkube.kit.common.KitLogger;

public class BuildJsonResponseHandler
implements EntityStreamReaderUtil.JsonEntityResponseHandler {
    private final KitLogger log;

    public BuildJsonResponseHandler(KitLogger log) {
        this.log = log;
    }

    @Override
    public void process(JsonObject json) throws DockerAccessException {
        if (json.has("error")) {
            String msg = json.get("error").getAsString();
            String detailMsg = "";
            if (json.has("errorDetail")) {
                JsonObject details = json.getAsJsonObject("errorDetail");
                detailMsg = details.get("message").getAsString();
            }
            throw new DockerAccessException("%s %s", json.get("error"), msg.equals(detailMsg) || "".equals(detailMsg) ? "" : "(" + detailMsg + ")");
        }
        if (json.has("stream")) {
            String message = json.get("stream").getAsString();
            this.log.verbose("%s", new Object[]{message.trim()});
        } else if (json.has("status")) {
            String id;
            String status = json.get("status").getAsString().trim();
            String string = id = json.has("id") ? json.get("id").getAsString() : null;
            if (status.matches("^.*(Download|Pulling).*")) {
                this.log.info("  %s%s", new Object[]{id != null ? id + " " : "", status});
            }
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

