/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.access;

import java.io.File;
import java.util.List;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.api.model.Container;
import org.eclipse.jkube.kit.build.api.model.ContainerDetails;
import org.eclipse.jkube.kit.build.api.model.ExecDetails;
import org.eclipse.jkube.kit.build.api.model.Network;
import org.eclipse.jkube.kit.build.api.model.NetworkCreateConfig;
import org.eclipse.jkube.kit.build.api.model.VolumeCreateConfig;
import org.eclipse.jkube.kit.build.service.docker.access.BuildOptions;
import org.eclipse.jkube.kit.build.service.docker.access.ContainerCreateConfig;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccessException;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogCallback;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogGetHandle;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogOutputSpec;
import org.eclipse.jkube.kit.common.archive.ArchiveCompression;
import org.eclipse.jkube.kit.config.image.build.Arguments;

public interface DockerAccess {
    public String getServerApiVersion() throws DockerAccessException;

    public ContainerDetails getContainer(String var1) throws DockerAccessException;

    public ExecDetails getExecContainer(String var1) throws DockerAccessException;

    public boolean hasImage(String var1) throws DockerAccessException;

    public String getImageId(String var1) throws DockerAccessException;

    public List<Container> getContainersForImage(String var1, boolean var2) throws DockerAccessException;

    public void startExecContainer(String var1, LogOutputSpec var2) throws DockerAccessException;

    public String createExecContainer(String var1, Arguments var2) throws DockerAccessException;

    public String createContainer(ContainerCreateConfig var1, String var2) throws DockerAccessException;

    public void startContainer(String var1) throws DockerAccessException;

    public void stopContainer(String var1, int var2) throws DockerAccessException;

    public void copyArchive(String var1, File var2, String var3) throws DockerAccessException;

    public void getLogSync(String var1, LogCallback var2);

    public LogGetHandle getLogAsync(String var1, LogCallback var2);

    public void removeContainer(String var1, boolean var2) throws DockerAccessException;

    public void loadImage(String var1, File var2) throws DockerAccessException;

    public void pullImage(String var1, AuthConfig var2, String var3) throws DockerAccessException;

    public void pushImage(String var1, AuthConfig var2, String var3, int var4) throws DockerAccessException;

    public void buildImage(String var1, File var2, BuildOptions var3) throws DockerAccessException;

    public void tag(String var1, String var2, boolean var3) throws DockerAccessException;

    public boolean removeImage(String var1, boolean ... var2) throws DockerAccessException;

    public void saveImage(String var1, String var2, ArchiveCompression var3) throws DockerAccessException;

    public List<Network> listNetworks() throws DockerAccessException;

    public String createNetwork(NetworkCreateConfig var1) throws DockerAccessException;

    public boolean removeNetwork(String var1) throws DockerAccessException;

    public void start() throws DockerAccessException;

    public void shutdown();

    public String createVolume(VolumeCreateConfig var1) throws DockerAccessException;

    public void removeVolume(String var1) throws DockerAccessException;
}

