/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class NavigateToDefinitionHandler {
    private final PreferenceManager preferenceManager;

    public NavigateToDefinitionHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<? extends Location> definition(TextDocumentPositionParams position, IProgressMonitor monitor) {
        ITypeRoot unit = JDTUtils.resolveTypeRoot(position.getTextDocument().getUri());
        Location location = null;
        if (unit != null && !monitor.isCanceled()) {
            location = this.computeDefinitionNavigation(unit, position.getPosition().getLine(), position.getPosition().getCharacter(), monitor);
        }
        if (location == null) {
            location = new Location();
            location.setRange(new Range());
        }
        return Arrays.asList(location);
    }

    private Location computeDefinitionNavigation(ITypeRoot unit, int line, int column, IProgressMonitor monitor) {
        IJavaElement element;
        block5: {
            element = JDTUtils.findElementAtSelection(unit, line, column, this.preferenceManager, monitor);
            if (element != null) break block5;
            return null;
        }
        try {
            ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
            IClassFile cf = (IClassFile)element.getAncestor(6);
            if (compilationUnit != null || cf != null && cf.getSourceRange() != null) {
                return JDTUtils.toLocation(element);
            }
            if (element instanceof IMember && ((IMember)element).getClassFile() != null) {
                return JDTUtils.toLocation(((IMember)element).getClassFile());
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Problem computing definition for" + unit.getElementName(), e);
        }
        return null;
    }
}

