/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class FormatterHandler {
    private PreferenceManager preferenceManager;

    public FormatterHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    List<? extends org.eclipse.lsp4j.TextEdit> formatting(DocumentFormattingParams params, IProgressMonitor monitor) {
        return this.format(params.getTextDocument().getUri(), params.getOptions(), null, monitor);
    }

    List<? extends org.eclipse.lsp4j.TextEdit> rangeFormatting(DocumentRangeFormattingParams params, IProgressMonitor monitor) {
        return this.format(params.getTextDocument().getUri(), params.getOptions(), params.getRange(), monitor);
    }

    private List<org.eclipse.lsp4j.TextEdit> format(String uri, FormattingOptions options, Range range, IProgressMonitor monitor) {
        if (!this.preferenceManager.getPreferences().isJavaFormatEnabled()) {
            return Collections.emptyList();
        }
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit(uri);
        if (cu == null) {
            return Collections.emptyList();
        }
        CodeFormatter formatter = ToolFactory.createCodeFormatter(FormatterHandler.getOptions(options, cu));
        try {
            Region region;
            IDocument document = JsonRpcHelpers.toDocument(cu.getBuffer());
            String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            Object object = region = range == null ? new Region(0, document.getLength()) : this.getRegion(range, document);
            if (region == null || monitor.isCanceled()) {
                return Collections.emptyList();
            }
            String sourceToFormat = document.get();
            TextEdit format = formatter.format(8, sourceToFormat, region.getOffset(), region.getLength(), 0, lineDelimiter);
            if (format == null || format.getChildren().length == 0 || monitor.isCanceled()) {
                return Collections.emptyList();
            }
            MultiTextEdit flatEdit = TextEditUtil.flatten((TextEdit)format);
            return FormatterHandler.convertEdits(flatEdit.getChildren(), document);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    private IRegion getRegion(Range range, IDocument document) {
        try {
            int offset = document.getLineOffset(range.getStart().getLine()) + range.getStart().getCharacter();
            int endOffset = document.getLineOffset(range.getEnd().getLine()) + range.getEnd().getCharacter();
            int length = endOffset - offset;
            return new Region(offset, length);
        }
        catch (BadLocationException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return null;
        }
    }

    private static Map<String, String> getOptions(FormattingOptions options, ICompilationUnit cu) {
        boolean insertSpaces;
        int tSize;
        Map eclipseOptions = cu.getJavaProject().getOptions(true);
        Map<String, String> customOptions = options.entrySet().stream().filter(map -> FormatterHandler.chekIfValueIsNotNull((Either3<String, Number, Boolean>)((Either3)map.getValue()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> FormatterHandler.getOptionValue((Either3<String, Number, Boolean>)((Either3)e.getValue()))));
        eclipseOptions.putAll(customOptions);
        Integer tabSize = options.getTabSize();
        if (tabSize != null && (tSize = tabSize.intValue()) > 0) {
            eclipseOptions.put("org.eclipse.jdt.core.formatter.tabulation.size", Integer.toString(tSize));
        }
        if (insertSpaces = options.isInsertSpaces()) {
            eclipseOptions.put("org.eclipse.jdt.core.formatter.tabulation.char", insertSpaces ? "space" : "tab");
        }
        return eclipseOptions;
    }

    private static boolean chekIfValueIsNotNull(Either3<String, Number, Boolean> value) {
        return value.getFirst() != null || value.getSecond() != null || value.getThird() != null;
    }

    private static String getOptionValue(Either3<String, Number, Boolean> option) {
        if (option.isFirst()) {
            return (String)option.getFirst();
        }
        if (option.isSecond()) {
            return ((Number)option.getSecond()).toString();
        }
        return ((Boolean)option.getThird()).toString();
    }

    private static List<org.eclipse.lsp4j.TextEdit> convertEdits(TextEdit[] edits, IDocument document) {
        return Arrays.stream(edits).map(t -> FormatterHandler.convertEdit(t, document)).collect(Collectors.toList());
    }

    private static org.eclipse.lsp4j.TextEdit convertEdit(TextEdit edit, IDocument document) {
        org.eclipse.lsp4j.TextEdit textEdit = new org.eclipse.lsp4j.TextEdit();
        if (edit instanceof ReplaceEdit) {
            ReplaceEdit replaceEdit = (ReplaceEdit)edit;
            textEdit.setNewText(replaceEdit.getText());
            int offset = edit.getOffset();
            textEdit.setRange(new Range(FormatterHandler.createPosition(document, offset), FormatterHandler.createPosition(document, offset + edit.getLength())));
        }
        return textEdit;
    }

    private static Position createPosition(IDocument document, int offset) {
        Position start = new Position();
        try {
            int lineOfOffset = document.getLineOfOffset(offset);
            start.setLine(Integer.valueOf(lineOfOffset).intValue());
            start.setCharacter(Integer.valueOf(offset - document.getLineOffset(lineOfOffset)).intValue());
        }
        catch (BadLocationException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        return start;
    }
}

