/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.BuildWorkspaceStatus;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceDiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;

public class BuildWorkspaceHandler {
    private JavaClientConnection connection;
    private final ProjectsManager projectsManager;

    public BuildWorkspaceHandler(JavaClientConnection connection, ProjectsManager projectsManager) {
        this.connection = connection;
        this.projectsManager = projectsManager;
    }

    public BuildWorkspaceStatus buildWorkspace(boolean forceReBuild, IProgressMonitor monitor) {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, monitor);
            if (monitor.isCanceled()) {
                return BuildWorkspaceStatus.CANCELLED;
            }
            ResourcesPlugin.getWorkspace().build(forceReBuild ? 6 : 10, monitor);
            List<IMarker> problemMarkers = BuildWorkspaceHandler.getProblemMarkers(monitor);
            this.publishDiagnostics(problemMarkers);
            List errors = problemMarkers.stream().filter(m -> m.getAttribute("severity", 0) == 2).map(e -> BuildWorkspaceHandler.convertMarker(e)).collect(Collectors.toList());
            if (errors.isEmpty()) {
                return BuildWorkspaceStatus.SUCCEED;
            }
            String newline = System.getProperty("line.separator");
            JavaLanguageServerPlugin.logError("Error occured while building workspace. Details: " + newline + String.join((CharSequence)newline, errors));
            return BuildWorkspaceStatus.WITH_ERROR;
        }
        catch (CoreException e2) {
            JavaLanguageServerPlugin.logException("Failed to build workspace.", e2);
            return BuildWorkspaceStatus.FAILED;
        }
        catch (OperationCanceledException e3) {
            return BuildWorkspaceStatus.CANCELLED;
        }
    }

    private static List<IMarker> getProblemMarkers(IProgressMonitor monitor) throws CoreException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            markers.addAll(Arrays.asList(project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2)));
            ++n2;
        }
        return markers;
    }

    private void publishDiagnostics(List<IMarker> markers) {
        Map<IResource, List<IMarker>> map = markers.stream().collect(Collectors.groupingBy(IMarker::getResource));
        for (Map.Entry<IResource, List<IMarker>> entry : map.entrySet()) {
            IFile file;
            IResource resource = entry.getKey();
            if (JavaLanguageServerPlugin.getProjectsManager().getDefaultProject().equals((Object)resource.getProject()) || (file = (IFile)resource.getAdapter(IFile.class)) == null) continue;
            IDocument document = null;
            String uri = JDTUtils.getFileURI(resource);
            if (JavaCore.isJavaLikeFileName((String)file.getName())) {
                ICompilationUnit cu = JDTUtils.resolveCompilationUnit(uri);
                try {
                    document = JsonRpcHelpers.toDocument(cu.getBuffer());
                }
                catch (JavaModelException e) {
                    JavaLanguageServerPlugin.logException("Failed to publish diagnostics.", e);
                }
            } else if (this.projectsManager.isBuildFile((IResource)file)) {
                document = JsonRpcHelpers.toDocument(file);
            }
            if (document == null) continue;
            List<Diagnostic> diagnostics = WorkspaceDiagnosticsHandler.toDiagnosticsArray(document, entry.getValue().toArray(new IMarker[0]));
            this.connection.publishDiagnostics(new PublishDiagnosticsParams(ResourceUtils.toClientUri(uri), diagnostics));
        }
    }

    private static String convertMarker(IMarker marker) {
        StringBuilder builder = new StringBuilder();
        String message = marker.getAttribute("message", "<no message>");
        String code = String.valueOf(marker.getAttribute("id", 0));
        builder.append("message: " + message + ";");
        builder.append("code: " + code);
        return builder.toString();
    }
}

