/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.EditAnnotator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;

public class CUCorrectionProposal
extends ChangeCorrectionProposal {
    private ICompilationUnit fCompilationUnit;

    public CUCorrectionProposal(String name, ICompilationUnit cu, TextChange change, int relevance) {
        super(name, (Change)change, relevance);
        if (cu == null) {
            throw new IllegalArgumentException("Compilation unit must not be null");
        }
        this.fCompilationUnit = cu;
    }

    protected CUCorrectionProposal(String name, ICompilationUnit cu, int relevance) {
        this(name, cu, null, relevance);
    }

    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
    }

    @Override
    public String getAdditionalProposalInfo(IProgressMonitor monitor) throws CoreException {
        StringBuffer buf = new StringBuffer();
        TextChange change = this.getTextChange();
        change.setKeepPreviewEdits(true);
        IDocument previewDocument = change.getPreviewDocument(monitor);
        TextEdit rootEdit = change.getPreviewEdit(change.getEdit());
        EditAnnotator ea = new EditAnnotator(buf, previewDocument);
        rootEdit.accept((TextEditVisitor)ea);
        ea.unchangedUntil(previewDocument.getLength());
        return buf.toString();
    }

    @Override
    public void apply() throws CoreException {
        this.performChange();
    }

    protected TextChange createTextChange() throws CoreException {
        CompilationUnitChange change;
        Document document;
        ICompilationUnit cu = this.getCompilationUnit();
        String name = this.getName();
        if (!cu.getResource().exists()) {
            String source;
            try {
                source = cu.getSource();
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.log(e.getStatus());
                source = new String();
            }
            document = new Document(source);
            change = new DocumentChange(name, (IDocument)document);
        } else {
            CompilationUnitChange cuChange = new CompilationUnitChange(name, cu);
            cuChange.setSaveMode(4);
            change = cuChange;
        }
        MultiTextEdit rootEdit = new MultiTextEdit();
        change.setEdit((TextEdit)rootEdit);
        document = change.getCurrentDocument((IProgressMonitor)new NullProgressMonitor());
        this.addEdits((IDocument)document, (TextEdit)rootEdit);
        return change;
    }

    @Override
    protected final Change createChange() throws CoreException {
        return this.createTextChange();
    }

    public final TextChange getTextChange() throws CoreException {
        return (TextChange)this.getChange();
    }

    public final ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public String getPreviewContent() throws CoreException {
        return this.getTextChange().getPreviewContent((IProgressMonitor)new NullProgressMonitor());
    }

    public String toString() {
        try {
            return this.getPreviewContent();
        }
        catch (CoreException coreException) {
            return super.toString();
        }
    }
}

