/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ls.core.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.ls.core.internal.corext.fix.PotentialProgrammingProblemsFix;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.IProblemLocation;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.FixCorrectionProposal;

public final class SerialVersionSubProcessor {
    public static final void getSerialVersionProposals(IInvocationContext context, IProblemLocation location, Collection<CUCorrectionProposal> proposals) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)location);
        Assert.isNotNull(proposals);
        IProposableFix[] fixes = PotentialProgrammingProblemsFix.createMissingSerialVersionFixes(context.getASTRoot(), location);
        if (fixes != null) {
            proposals.add(new SerialVersionProposal(fixes[0], 9, context, true));
            ICompilationUnit unit = context.getCompilationUnit();
            if (unit != null && unit.getJavaProject() != null && !"jdt.ls-java-project".equals(unit.getJavaProject().getProject().getName())) {
                proposals.add(new SerialVersionProposal(fixes[1], 9, context, false));
            }
        }
    }

    public static final class SerialVersionProposal
    extends FixCorrectionProposal {
        private boolean fIsDefaultProposal;

        public SerialVersionProposal(IProposableFix fix, int relevance, IInvocationContext context, boolean isDefault) {
            super(fix, relevance, context);
            this.fIsDefaultProposal = isDefault;
        }

        public boolean isDefaultProposal() {
            return this.fIsDefaultProposal;
        }

        @Override
        public String getAdditionalProposalInfo(IProgressMonitor monitor) {
            if (this.fIsDefaultProposal) {
                return CorrectionMessages.SerialVersionDefaultProposal_message_default_info;
            }
            return CorrectionMessages.SerialVersionHashProposal_message_generated_info;
        }
    }
}

