/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.IProblemLocation;
import org.eclipse.jdt.ls.core.internal.corrections.ReturnTypeSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.SerialVersionSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.JavadocTagsSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.LocalCorrectionsSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ReorgCorrectionsSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ReplaceCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.TypeMismatchSubProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.UnresolvedElementsSubProcessor;

public class QuickFixProcessor {
    private static int moveBack(int offset, int start, String ignoreCharacters, ICompilationUnit cu) {
        try {
            IBuffer buf = cu.getBuffer();
            while (offset >= start) {
                if (ignoreCharacters.indexOf(buf.getChar(offset - 1)) == -1) {
                    return offset;
                }
                --offset;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return start;
    }

    public CUCorrectionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations == null || locations.length == 0) {
            return new CUCorrectionProposal[0];
        }
        HashSet<Integer> handledProblems = new HashSet<Integer>(locations.length);
        ArrayList<CUCorrectionProposal> resultingCollections = new ArrayList<CUCorrectionProposal>();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation curr = locations[i];
            Integer id = new Integer(curr.getProblemId());
            if (handledProblems.add(id)) {
                this.process(context, curr, resultingCollections);
            }
            ++i;
        }
        return resultingCollections.toArray(new CUCorrectionProposal[resultingCollections.size()]);
    }

    private void process(IInvocationContext context, IProblemLocation problem, Collection<CUCorrectionProposal> proposals) throws CoreException {
        int id = problem.getProblemId();
        if (id == 0) {
            return;
        }
        switch (id) {
            case 1610612995: {
                String quoteLabel = CorrectionMessages.JavaCorrectionProcessor_addquote_description;
                int pos = QuickFixProcessor.moveBack(problem.getOffset() + problem.getLength(), problem.getOffset(), "\n\r", context.getCompilationUnit());
                proposals.add(new ReplaceCorrectionProposal(quoteLabel, context.getCompilationUnit(), pos, 0, "\"", 0));
                break;
            }
            case 0x10000181: 
            case 268435842: 
            case 268435843: 
            case 268435844: 
            case 268435846: {
                ReorgCorrectionsSubProcessor.removeImportStatementProposals(context, problem, proposals);
                break;
            }
            case 16777541: {
                ReorgCorrectionsSubProcessor.getWrongTypeNameProposals(context, problem, proposals);
                break;
            }
            case 536871240: {
                ReorgCorrectionsSubProcessor.getWrongPackageDeclNameProposals(context, problem, proposals);
                break;
            }
            case 0x4000064: {
                UnresolvedElementsSubProcessor.getMethodProposals(context, problem, false, proposals);
                break;
            }
            case 0x8000082: {
                UnresolvedElementsSubProcessor.getConstructorProposals(context, problem, proposals);
                break;
            }
            case 67109475: {
                UnresolvedElementsSubProcessor.getAnnotationMemberProposals(context, problem, proposals);
                break;
            }
            case 67108979: {
                UnresolvedElementsSubProcessor.getMethodProposals(context, problem, true, proposals);
                break;
            }
            case 33554502: 
            case 33554515: 
            case 0x22000032: {
                UnresolvedElementsSubProcessor.getVariableProposals(context, problem, null, proposals);
                break;
            }
            case -1610612231: 
            case 0x1000004: {
                UnresolvedElementsSubProcessor.getAmbiguousTypeReferenceProposals(context, problem, proposals);
                break;
            }
            case -1610612233: 
            case 0x1000002: {
                UnresolvedElementsSubProcessor.getTypeProposals(context, problem, proposals);
                break;
            }
            case 0x1000011: 
            case 0x1000013: {
                TypeMismatchSubProcessor.addTypeMismatchProposals(context, problem, proposals);
                break;
            }
            case 16777796: {
                TypeMismatchSubProcessor.addTypeMismatchInForEachProposals(context, problem, proposals);
                break;
            }
            case 67109268: {
                TypeMismatchSubProcessor.addIncompatibleReturnTypeProposals(context, problem, proposals);
                break;
            }
            case 67109266: {
                TypeMismatchSubProcessor.addIncompatibleThrowsProposals(context, problem, proposals);
                break;
            }
            case 16777384: 
            case 16778098: {
                LocalCorrectionsSubProcessor.addUncaughtExceptionProposals(context, problem, proposals);
                break;
            }
            case 83886247: 
            case 553648315: 
            case 553649001: {
                LocalCorrectionsSubProcessor.addUnreachableCatchProposals(context, problem, proposals);
                break;
            }
            case 67108969: {
                ReturnTypeSubProcessor.addVoidMethodReturnsProposals(context, problem, proposals);
                break;
            }
            case 67108970: {
                ReturnTypeSubProcessor.addMethodReturnsVoidProposals(context, problem, proposals);
                break;
            }
            case 16777327: {
                ReturnTypeSubProcessor.addMissingReturnTypeProposals(context, problem, proposals);
                break;
            }
            case 0x4000303: 
            case 603979884: {
                ReturnTypeSubProcessor.addMissingReturnStatementProposals(context, problem, proposals);
                break;
            }
            case 67109264: 
            case 67109627: {
                LocalCorrectionsSubProcessor.addUnimplementedMethodsProposals(context, problem, proposals);
                break;
            }
            case 536870973: 
            case 536870974: 
            case 553648135: 
            case 570425421: 
            case 603979894: 
            case 603979910: {
                LocalCorrectionsSubProcessor.addUnusedMemberProposal(context, problem, proposals);
                break;
            }
            case -1610612250: {
                JavadocTagsSubProcessor.getMissingJavadocCommentProposals(context, problem, proposals);
                break;
            }
            case -1610612265: 
            case -1610612261: 
            case -1610612259: {
                JavadocTagsSubProcessor.getMissingJavadocTagProposals(context, problem, proposals);
                break;
            }
            case -1610612266: 
            case -1610612263: 
            case -1610612262: 
            case -1610612260: 
            case -1610612256: 
            case -1610612255: 
            case -1610612249: {
                JavadocTagsSubProcessor.getRemoveJavadocTagProposals(context, problem, proposals);
                break;
            }
            case -1610612270: {
                JavadocTagsSubProcessor.getInvalidQualificationProposals(context, problem, proposals);
                break;
            }
            case 0x4000074: {
                UnresolvedElementsSubProcessor.getArrayAccessProposals(context, problem, proposals);
                break;
            }
            case 0x20000060: {
                SerialVersionSubProcessor.getSerialVersionProposals(context, problem, proposals);
                break;
            }
            default: {
                String str = problem.toString();
                System.out.println(str);
            }
        }
    }
}

