/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.ls.core.internal.corrections.IProblemLocation;

public class ProblemLocation
implements IProblemLocation {
    private int offset;
    private int length;
    private int problemId;
    private boolean isError;

    public ProblemLocation(int offset, int length, int problemId, boolean isError) {
        this.offset = offset;
        this.length = length;
        this.problemId = problemId;
        this.isError = isError;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public String getMarkerType() {
        return "org.eclipse.jdt.core.problem";
    }

    @Override
    public int getProblemId() {
        return this.problemId;
    }

    @Override
    public String[] getProblemArguments() {
        return new String[0];
    }

    @Override
    public boolean isError() {
        return this.isError;
    }

    @Override
    public ASTNode getCoveringNode(CompilationUnit astRoot) {
        NodeFinder finder = new NodeFinder((ASTNode)astRoot, this.offset, this.length);
        return finder.getCoveringNode();
    }

    @Override
    public ASTNode getCoveredNode(CompilationUnit astRoot) {
        NodeFinder finder = new NodeFinder((ASTNode)astRoot, this.offset, this.length);
        return finder.getCoveredNode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Id: ").append(this.getErrorCode(this.problemId)).append('\n');
        buf.append('[').append(this.offset).append(", ").append(this.length).append(']').append('\n');
        return buf.toString();
    }

    private String getErrorCode(int code) {
        StringBuffer buf = new StringBuffer();
        if ((code & 0x1000000) != 0) {
            buf.append("TypeRelated + ");
        }
        if ((code & 0x2000000) != 0) {
            buf.append("FieldRelated + ");
        }
        if ((code & 0x8000000) != 0) {
            buf.append("ConstructorRelated + ");
        }
        if ((code & 0x4000000) != 0) {
            buf.append("MethodRelated + ");
        }
        if ((code & 0x10000000) != 0) {
            buf.append("ImportRelated + ");
        }
        if ((code & 0x20000000) != 0) {
            buf.append("Internal + ");
        }
        if ((code & 0x40000000) != 0) {
            buf.append("Syntax + ");
        }
        if ((code & Integer.MIN_VALUE) != 0) {
            buf.append("Javadoc + ");
        }
        buf.append(code & 0x7FFFFF);
        return buf.toString();
    }
}

