/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.commands;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.TextEditConverter;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.ls.core.internal.corrections.InnovationContext;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;

public class OrganizeImportsCommand {
    public static Object organizeImports(List<Object> arguments) throws CoreException {
        if (arguments == null || arguments.isEmpty()) {
            return new WorkspaceEdit();
        }
        Object arg1 = arguments.get(0);
        if (arg1 instanceof String) {
            String fileUri = (String)arg1;
            OrganizeImportsCommand command = new OrganizeImportsCommand();
            IPath rootPath = ResourceUtils.filePathFromURI(fileUri);
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            boolean selectProjectRoot = false;
            IProject targetProj = null;
            if (rootPath != null && projects.length > 0) {
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject proj = iProjectArray[n2];
                    String projectLocation = proj.getLocation().toString().toLowerCase();
                    String selectedPath = rootPath.toString().toLowerCase();
                    if (!StringUtils.isBlank((CharSequence)selectedPath) && !StringUtils.isBlank((CharSequence)projectLocation) && selectedPath.startsWith(projectLocation)) {
                        targetProj = proj;
                        if (!projectLocation.equals(selectedPath)) break;
                        selectProjectRoot = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (targetProj != null && selectProjectRoot) {
                return command.organizeImportsInProject(targetProj);
            }
            URI uri = URI.create(fileUri);
            File file = new File(uri.getPath());
            boolean exists = file.exists();
            if (!exists) {
                return new WorkspaceEdit();
            }
            if (file.isDirectory()) {
                return command.organizeImportsInDirectory(fileUri, targetProj);
            }
            return command.organizeImportsInFile(fileUri);
        }
        return new WorkspaceEdit();
    }

    public WorkspaceEdit organizeImportsInProject(IProject proj) {
        WorkspaceEdit rootEdit = new WorkspaceEdit();
        HashSet<IJavaElement> result = new HashSet<IJavaElement>();
        this.collectCompilationUnits(JavaCore.create((IProject)proj), result, null);
        for (IJavaElement elem : result) {
            if (elem.getElementType() != 5) continue;
            this.organizeImportsInCompilationUnit((ICompilationUnit)elem, rootEdit);
        }
        return rootEdit;
    }

    public WorkspaceEdit organizeImportsInDirectory(String folderUri, IProject proj) throws CoreException {
        WorkspaceEdit rootEdit = new WorkspaceEdit();
        IPackageFragment fragment = null;
        if (JDTUtils.toURI(folderUri) != null) {
            fragment = JDTUtils.resolvePackage(folderUri);
        }
        if (fragment != null) {
            this.organizeImportsInPackageFragment(fragment, rootEdit);
        } else if (proj != null) {
            IJavaProject javaProject = JavaCore.create((IProject)proj);
            IPath rootPath = ResourceUtils.filePathFromURI(folderUri);
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            HashSet<IJavaElement> result = new HashSet<IJavaElement>();
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                String packageRoot;
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getKind() == 1 && (packageRoot = root.getResource().getLocation().toString()).toLowerCase().indexOf(rootPath.toString().toLowerCase()) >= 0) {
                    this.collectCompilationUnits(javaProject, result, null);
                }
                ++n2;
            }
            for (IJavaElement elem : result) {
                if (elem.getElementType() != 5) continue;
                this.organizeImportsInCompilationUnit((ICompilationUnit)elem, rootEdit);
            }
        }
        return rootEdit;
    }

    public WorkspaceEdit organizeImportsInFile(String fileUri) {
        WorkspaceEdit rootEdit = new WorkspaceEdit();
        ICompilationUnit unit = null;
        if (JDTUtils.toURI(fileUri) != null) {
            unit = JDTUtils.resolveCompilationUnit(fileUri);
        }
        if (unit == null) {
            return rootEdit;
        }
        this.organizeImportsInCompilationUnit(unit, rootEdit);
        return rootEdit;
    }

    public void organizeImportsInPackageFragment(IPackageFragment fragment, WorkspaceEdit rootEdit) throws CoreException {
        HashSet<IJavaElement> result = new HashSet<IJavaElement>();
        this.collectCompilationUnits(fragment.getParent(), result, fragment.getElementName());
        for (IJavaElement elem : result) {
            if (elem.getElementType() != 5) continue;
            this.organizeImportsInCompilationUnit((ICompilationUnit)elem, rootEdit);
        }
    }

    public void organizeImportsInCompilationUnit(final ICompilationUnit unit, WorkspaceEdit rootEdit) {
        try {
            final InnovationContext context = new InnovationContext(unit, 0, unit.getBuffer().getLength() - 1);
            CUCorrectionProposal proposal = new CUCorrectionProposal("OrganizeImports", unit, 5){

                @Override
                protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
                    CompilationUnit astRoot = context.getASTRoot();
                    OrganizeImportsOperation op = new OrganizeImportsOperation(unit, astRoot, true, false, true, null);
                    editRoot.addChild(op.createTextEdit(null));
                }
            };
            this.addWorkspaceEdit(unit, proposal, rootEdit);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem organize imports ", e);
        }
    }

    private void collectCompilationUnits(Object element, Collection<IJavaElement> result, String packagePrefix) {
        block12: {
            try {
                IJavaElement elem;
                if (!(element instanceof IJavaElement) || !(elem = (IJavaElement)element).exists()) break block12;
                switch (elem.getElementType()) {
                    case 7: {
                        if (elem.getParent().getElementType() == 5) {
                            result.add(elem.getParent());
                        }
                        break;
                    }
                    case 5: {
                        result.add(elem);
                        break;
                    }
                    case 12: {
                        result.add(elem.getParent());
                        break;
                    }
                    case 4: {
                        this.collectCompilationUnits((IPackageFragment)elem, result);
                        break;
                    }
                    case 3: {
                        this.collectCompilationUnits((IPackageFragmentRoot)elem, result, packagePrefix);
                        break;
                    }
                    case 2: {
                        IPackageFragmentRoot[] roots = ((IJavaProject)elem).getPackageFragmentRoots();
                        int k = 0;
                        while (k < roots.length) {
                            this.collectCompilationUnits(roots[k], result, (String)null);
                            ++k;
                        }
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem collection compilation unit ", e);
            }
        }
    }

    private void collectCompilationUnits(IPackageFragment pack, Collection<IJavaElement> result) throws JavaModelException {
        result.addAll(Arrays.asList(pack.getCompilationUnits()));
    }

    private void collectCompilationUnits(IPackageFragmentRoot root, Collection<IJavaElement> result, String prefix) throws JavaModelException {
        if (root.getKind() == 1) {
            IJavaElement[] children = root.getChildren();
            int i = 0;
            while (i < children.length) {
                IPackageFragment pack = (IPackageFragment)children[i];
                if (StringUtils.isBlank((CharSequence)prefix) || pack.getElementName().indexOf(prefix) >= 0) {
                    this.collectCompilationUnits(pack, result);
                }
                ++i;
            }
        }
    }

    private void addWorkspaceEdit(ICompilationUnit cu, CUCorrectionProposal proposal, WorkspaceEdit rootEdit) throws CoreException {
        TextChange textChange = proposal.getTextChange();
        TextEdit edit = textChange.getEdit();
        TextEditConverter converter = new TextEditConverter(cu, edit);
        rootEdit.getChanges().put(JDTUtils.toURI(cu), converter.convert());
    }
}

