/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public final class ProjectUtils {
    private ProjectUtils() {
    }

    public static boolean hasNature(IProject project, String natureId) {
        try {
            return project != null && project.hasNature(natureId);
        }
        catch (CoreException e) {
            return false;
        }
    }

    public static boolean isJavaProject(IProject project) {
        return ProjectUtils.hasNature(project, "org.eclipse.jdt.core.javanature");
    }

    public static boolean isMavenProject(IProject project) {
        return ProjectUtils.hasNature(project, "org.eclipse.m2e.core.maven2Nature");
    }

    public static boolean isGradleProject(IProject project) {
        return ProjectUtils.hasNature(project, "org.eclipse.buildship.core.gradleprojectnature");
    }

    public static String getJavaSourceLevel(IProject project) {
        if (!ProjectUtils.isJavaProject(project)) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        Map options = javaProject.getOptions(true);
        return (String)options.get("org.eclipse.jdt.core.compiler.source");
    }

    public static List<IProject> getGradleProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        return Stream.of(projects).filter(ProjectUtils::isGradleProject).collect(Collectors.toList());
    }
}

