/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.ls.core.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.ls.core.internal.corext.dom.Bindings;
import org.eclipse.jdt.ls.core.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.IProblemLocation;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.RefactoringCorrectionProposal;

public class QuickAssistProcessor {
    public static final String SPLIT_JOIN_VARIABLE_DECLARATION_ID = "org.eclipse.jdt.ls.correction.splitJoinVariableDeclaration.assist";
    public static final String CONVERT_FOR_LOOP_ID = "org.eclipse.jdt.ls.correction.convertForLoop.assist";
    public static final String ASSIGN_TO_LOCAL_ID = "org.eclipse.jdt.ls.correction.assignToLocal.assist";
    public static final String ASSIGN_TO_FIELD_ID = "org.eclipse.jdt.ls.correction.assignToField.assist";
    public static final String ASSIGN_PARAM_TO_FIELD_ID = "org.eclipse.jdt.ls.correction.assignParamToField.assist";
    public static final String ASSIGN_ALL_PARAMS_TO_NEW_FIELDS_ID = "org.eclipse.jdt.ls.correction.assignAllParamsToNewFields.assist";
    public static final String ADD_BLOCK_ID = "org.eclipse.jdt.ls.correction.addBlock.assist";
    public static final String EXTRACT_LOCAL_ID = "org.eclipse.jdt.ls.correction.extractLocal.assist";
    public static final String EXTRACT_LOCAL_NOT_REPLACE_ID = "org.eclipse.jdt.ls.correction.extractLocalNotReplaceOccurrences.assist";
    public static final String EXTRACT_CONSTANT_ID = "org.eclipse.jdt.ls.correction.extractConstant.assist";
    public static final String INLINE_LOCAL_ID = "org.eclipse.jdt.ls.correction.inlineLocal.assist";
    public static final String CONVERT_LOCAL_TO_FIELD_ID = "org.eclipse.jdt.ls.correction.convertLocalToField.assist";
    public static final String CONVERT_ANONYMOUS_TO_LOCAL_ID = "org.eclipse.jdt.ls.correction.convertAnonymousToLocal.assist";
    public static final String CONVERT_TO_STRING_BUFFER_ID = "org.eclipse.jdt.ls.correction.convertToStringBuffer.assist";
    public static final String CONVERT_TO_MESSAGE_FORMAT_ID = "org.eclipse.jdt.ls.correction.convertToMessageFormat.assist";
    public static final String EXTRACT_METHOD_INPLACE_ID = "org.eclipse.jdt.ls.correction.extractMethodInplace.assist";

    public CUCorrectionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList<ASTNode> coveredNodes = QuickAssistProcessor.getFullyCoveredNodes(context, coveringNode);
            ArrayList<CUCorrectionProposal> resultingCollections = new ArrayList<CUCorrectionProposal>();
            boolean noErrorsAtLocation = QuickAssistProcessor.noErrorsAtLocation(locations);
            if (noErrorsAtLocation) {
                boolean problemsAtLocation = locations.length != 0;
                QuickAssistProcessor.getExtractMethodProposal(context, coveringNode, problemsAtLocation, resultingCollections);
            }
            return resultingCollections.toArray(new CUCorrectionProposal[resultingCollections.size()]);
        }
        return new CUCorrectionProposal[0];
    }

    static ArrayList<ASTNode> getFullyCoveredNodes(IInvocationContext context, ASTNode coveringNode) {
        final ArrayList<ASTNode> coveredNodes = new ArrayList<ASTNode>();
        final int selectionBegin = context.getSelectionOffset();
        final int selectionEnd = selectionBegin + context.getSelectionLength();
        coveringNode.accept((ASTVisitor)new GenericVisitor(){

            protected boolean visitNode(ASTNode node) {
                ASTNode parent;
                int nodeStart = node.getStartPosition();
                int nodeEnd = nodeStart + node.getLength();
                if (nodeEnd < selectionBegin || selectionEnd < nodeStart) {
                    return false;
                }
                if (this.isCovered(node) && ((parent = node.getParent()) == null || !this.isCovered(parent))) {
                    coveredNodes.add(node);
                    return false;
                }
                return true;
            }

            private boolean isCovered(ASTNode node) {
                int begin = node.getStartPosition();
                int end = begin + node.getLength();
                return begin >= selectionBegin && end <= selectionEnd;
            }
        });
        return coveredNodes;
    }

    static boolean noErrorsAtLocation(IProblemLocation[] locations) {
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                IProblemLocation location = locations[i];
                if (location.isError() && (!"org.eclipse.jdt.core.problem".equals(location.getMarkerType()) || JavaCore.getOptionForConfigurableSeverity((int)location.getProblemId()) == null)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static int getIndex(int offset, List<Statement> statements) {
        int i = 0;
        while (i < statements.size()) {
            Statement s = statements.get(i);
            if (offset <= s.getStartPosition()) {
                return i;
            }
            if (offset < s.getStartPosition() + s.getLength()) {
                return -1;
            }
            ++i;
        }
        return statements.size();
    }

    private static boolean getExtractMethodProposal(IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, Collection<CUCorrectionProposal> proposals) throws CoreException {
        if (!(coveringNode instanceof Expression || coveringNode instanceof Statement || coveringNode instanceof Block)) {
            return false;
        }
        if (coveringNode instanceof Block) {
            List statements = ((Block)coveringNode).statements();
            int startIndex = QuickAssistProcessor.getIndex(context.getSelectionOffset(), statements);
            if (startIndex == -1) {
                return false;
            }
            int endIndex = QuickAssistProcessor.getIndex(context.getSelectionOffset() + context.getSelectionLength(), statements);
            if (endIndex == -1 || endIndex <= startIndex) {
                return false;
            }
        }
        if (proposals == null) {
            return true;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ExtractMethodRefactoring extractMethodRefactoring = new ExtractMethodRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength());
        String uniqueMethodName = QuickAssistProcessor.getUniqueMethodName(coveringNode, "extracted");
        extractMethodRefactoring.setMethodName(uniqueMethodName);
        if (extractMethodRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            String label = CorrectionMessages.QuickAssistProcessor_extractmethod_description;
            LinkedProposalModel linkedProposalModel = new LinkedProposalModel();
            extractMethodRefactoring.setLinkedProposalModel(linkedProposalModel);
            int relevance = problemsAtLocation ? 1 : 4;
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, cu, extractMethodRefactoring, relevance);
            proposal.setLinkedProposalModel(linkedProposalModel);
            proposals.add(proposal);
        }
        return true;
    }

    public static IMethodBinding getFunctionalMethodForMethodReference(MethodReference methodReference) {
        ITypeBinding targetTypeBinding = ASTNodes.getTargetType((Expression)methodReference);
        if (targetTypeBinding == null) {
            return null;
        }
        IMethodBinding functionalMethod = targetTypeBinding.getFunctionalInterfaceMethod();
        if (functionalMethod.isSynthetic()) {
            functionalMethod = Bindings.findOverriddenMethodInType(functionalMethod.getDeclaringClass(), functionalMethod);
        }
        return functionalMethod;
    }

    public static LambdaExpression convertMethodRefernceToLambda(MethodReference methodReference, IMethodBinding functionalMethod, CompilationUnit astRoot, ASTRewrite rewrite, LinkedProposalModel linkedProposalModel, boolean createBlockBody) throws JavaModelException {
        MethodInvocation methodInvocation;
        AST ast = astRoot.getAST();
        LambdaExpression lambda = ast.newLambdaExpression();
        String[] lambdaParamNames = QuickAssistProcessor.getUniqueParameterNames(methodReference, functionalMethod);
        List lambdaParameters = lambda.parameters();
        int i = 0;
        while (i < lambdaParamNames.length) {
            String paramName = lambdaParamNames[i];
            VariableDeclarationFragment lambdaParameter = ast.newVariableDeclarationFragment();
            SimpleName name = ast.newSimpleName(paramName);
            lambdaParameter.setName(name);
            lambdaParameters.add(lambdaParameter);
            if (linkedProposalModel != null) {
                linkedProposalModel.getPositionGroup(name.getIdentifier(), true).addPosition(rewrite.track((ASTNode)name), i == 0);
            }
            ++i;
        }
        int noOfLambdaParameters = lambdaParamNames.length;
        lambda.setParentheses(noOfLambdaParameters != 1);
        ITypeBinding returnTypeBinding = functionalMethod.getReturnType();
        IMethodBinding referredMethodBinding = methodReference.resolveMethodBinding();
        if (methodReference instanceof CreationReference) {
            CreationReference creationRef = (CreationReference)methodReference;
            Type type = creationRef.getType();
            if (type instanceof ArrayType) {
                ArrayCreation arrayCreation = ast.newArrayCreation();
                if (createBlockBody) {
                    Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)arrayCreation, returnTypeBinding, ast);
                    lambda.setBody((ASTNode)blockBody);
                } else {
                    lambda.setBody((ASTNode)arrayCreation);
                }
                ArrayType arrayType = (ArrayType)type;
                Type copiedElementType = (Type)rewrite.createCopyTarget((ASTNode)arrayType.getElementType());
                arrayCreation.setType(ast.newArrayType(copiedElementType, arrayType.getDimensions()));
                SimpleName name = ast.newSimpleName(lambdaParamNames[0]);
                arrayCreation.dimensions().add(name);
                if (linkedProposalModel != null) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            } else {
                ClassInstanceCreation cic = ast.newClassInstanceCreation();
                if (createBlockBody) {
                    Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)cic, returnTypeBinding, ast);
                    lambda.setBody((ASTNode)blockBody);
                } else {
                    lambda.setBody((ASTNode)cic);
                }
                ITypeBinding typeBinding = type.resolveBinding();
                if (!(type instanceof ParameterizedType) && typeBinding != null && typeBinding.getTypeDeclaration().isGenericType()) {
                    cic.setType((Type)ast.newParameterizedType((Type)rewrite.createCopyTarget((ASTNode)type)));
                } else {
                    cic.setType((Type)rewrite.createCopyTarget((ASTNode)type));
                }
                List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
                cic.arguments().addAll(invocationArgs);
                if (linkedProposalModel != null) {
                    for (SimpleName name : invocationArgs) {
                        linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                    }
                }
                cic.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
            }
        } else if (referredMethodBinding != null && Modifier.isStatic((int)referredMethodBinding.getModifiers())) {
            methodInvocation = ast.newMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)methodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)methodInvocation);
            }
            Expression expr = null;
            boolean hasConflict = QuickAssistProcessor.hasConflict(methodReference.getStartPosition(), referredMethodBinding, 17, astRoot);
            if (hasConflict || !Bindings.isSuperType(referredMethodBinding.getDeclaringClass(), ASTNodes.getEnclosingType((ASTNode)methodReference)) || methodReference.typeArguments().size() != 0) {
                Type type;
                ITypeBinding typeBinding;
                if (methodReference instanceof ExpressionMethodReference) {
                    ExpressionMethodReference expressionMethodReference = (ExpressionMethodReference)methodReference;
                    expr = (Expression)rewrite.createCopyTarget((ASTNode)expressionMethodReference.getExpression());
                } else if (methodReference instanceof TypeMethodReference && (typeBinding = (type = ((TypeMethodReference)methodReference).getType()).resolveBinding()) != null) {
                    ImportRewrite importRewrite = StubUtility.createImportRewrite(astRoot, true);
                    expr = ast.newName(importRewrite.addImport(typeBinding));
                }
            }
            methodInvocation.setExpression(expr);
            SimpleName methodName = QuickAssistProcessor.getMethodInvocationName(methodReference);
            methodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
            methodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            methodInvocation.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        } else if (methodReference instanceof SuperMethodReference) {
            SuperMethodInvocation superMethodInvocation = ast.newSuperMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)superMethodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)superMethodInvocation);
            }
            Name superQualifier = ((SuperMethodReference)methodReference).getQualifier();
            if (superQualifier != null) {
                superMethodInvocation.setQualifier((Name)rewrite.createCopyTarget((ASTNode)superQualifier));
            }
            SimpleName methodName = QuickAssistProcessor.getMethodInvocationName(methodReference);
            superMethodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
            superMethodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            superMethodInvocation.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        } else {
            methodInvocation = ast.newMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)methodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)methodInvocation);
            }
            boolean isTypeReference = QuickAssistProcessor.isTypeReferenceToInstanceMethod(methodReference);
            if (isTypeReference) {
                SimpleName name = ast.newSimpleName(lambdaParamNames[0]);
                methodInvocation.setExpression((Expression)name);
                if (linkedProposalModel != null) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            } else {
                Expression expr = ((ExpressionMethodReference)methodReference).getExpression();
                if (!(expr instanceof ThisExpression) || methodReference.typeArguments().size() != 0) {
                    methodInvocation.setExpression((Expression)rewrite.createCopyTarget((ASTNode)expr));
                }
            }
            SimpleName methodName = QuickAssistProcessor.getMethodInvocationName(methodReference);
            methodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, isTypeReference ? 1 : 0, noOfLambdaParameters, lambdaParamNames);
            methodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            methodInvocation.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        }
        rewrite.replace((ASTNode)methodReference, (ASTNode)lambda, null);
        return lambda;
    }

    private static boolean hasConflict(int startPosition, IMethodBinding referredMethodBinding, int flags, CompilationUnit cu) {
        ScopeAnalyzer analyzer = new ScopeAnalyzer(cu);
        IBinding[] declarationsInScope = analyzer.getDeclarationsInScope(startPosition, flags);
        int i = 0;
        while (i < declarationsInScope.length) {
            IBinding decl = declarationsInScope[i];
            if (decl.getName().equals(referredMethodBinding.getName()) && !referredMethodBinding.getMethodDeclaration().isEqualTo(decl)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String[] getUniqueParameterNames(MethodReference methodReference, IMethodBinding functionalMethod) throws JavaModelException {
        String[] parameterNames = ((IMethod)functionalMethod.getJavaElement()).getParameterNames();
        ArrayList<String> oldNames = new ArrayList<String>(Arrays.asList(parameterNames));
        String[] newNames = new String[oldNames.size()];
        ArrayList<String> excludedNames = new ArrayList<String>(ASTNodes.getVisibleLocalVariablesInScope((ASTNode)methodReference));
        int i = 0;
        while (i < oldNames.size()) {
            String paramName = (String)oldNames.get(i);
            ArrayList<String> allNamesToExclude = new ArrayList<String>(excludedNames);
            allNamesToExclude.addAll(oldNames.subList(0, i));
            allNamesToExclude.addAll(oldNames.subList(i + 1, oldNames.size()));
            if (allNamesToExclude.contains(paramName)) {
                String newParamName = QuickAssistProcessor.createName(paramName, allNamesToExclude);
                excludedNames.add(newParamName);
                newNames[i] = newParamName;
            } else {
                newNames[i] = paramName;
            }
            ++i;
        }
        return newNames;
    }

    private static String getUniqueMethodName(ASTNode astNode, String suggestedName) throws JavaModelException {
        while (astNode != null && !(astNode instanceof TypeDeclaration)) {
            astNode = astNode.getParent();
        }
        if (astNode instanceof TypeDeclaration) {
            ITypeBinding typeBinding = ((TypeDeclaration)astNode).resolveBinding();
            if (typeBinding == null) {
                return suggestedName;
            }
            IType type = (IType)typeBinding.getJavaElement();
            if (type == null) {
                return suggestedName;
            }
            IMethod[] methods = type.getMethods();
            int suggestedPostfix = 2;
            String resultName = suggestedName;
            while (suggestedPostfix < 1000) {
                if (!QuickAssistProcessor.hasMethod(methods, resultName)) {
                    return resultName;
                }
                resultName = String.valueOf(suggestedName) + suggestedPostfix++;
            }
        }
        return suggestedName;
    }

    private static boolean hasMethod(IMethod[] methods, String name) {
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (name.equals(method.getElementName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String createName(String candidate, List<String> excludedNames) {
        int i = 1;
        String result = candidate;
        while (excludedNames.contains(result)) {
            result = String.valueOf(candidate) + i++;
        }
        return result;
    }

    private static boolean isTypeReferenceToInstanceMethod(MethodReference methodReference) {
        IBinding nameBinding;
        Expression expression;
        if (methodReference instanceof TypeMethodReference) {
            return true;
        }
        return methodReference instanceof ExpressionMethodReference && (expression = ((ExpressionMethodReference)methodReference).getExpression()) instanceof Name && (nameBinding = ((Name)expression).resolveBinding()) != null && nameBinding instanceof ITypeBinding;
    }

    private static List<SimpleName> getInvocationArguments(AST ast, int begIndex, int noOfLambdaParameters, String[] lambdaParamNames) {
        ArrayList<SimpleName> args = new ArrayList<SimpleName>();
        int i = begIndex;
        while (i < noOfLambdaParameters) {
            args.add(ast.newSimpleName(lambdaParamNames[i]));
            ++i;
        }
        return args;
    }

    private static List<Type> getCopiedTypeArguments(ASTRewrite rewrite, List<Type> typeArguments) {
        ArrayList<Type> copiedTypeArgs = new ArrayList<Type>();
        for (Type typeArg : typeArguments) {
            copiedTypeArgs.add((Type)rewrite.createCopyTarget((ASTNode)typeArg));
        }
        return copiedTypeArgs;
    }

    private static SimpleName getMethodInvocationName(MethodReference methodReference) {
        SimpleName name = null;
        if (methodReference instanceof ExpressionMethodReference) {
            name = ((ExpressionMethodReference)methodReference).getName();
        } else if (methodReference instanceof TypeMethodReference) {
            name = ((TypeMethodReference)methodReference).getName();
        } else if (methodReference instanceof SuperMethodReference) {
            name = ((SuperMethodReference)methodReference).getName();
        }
        return name;
    }

    public static void changeLambdaBodyToBlock(LambdaExpression lambda, AST ast, ASTRewrite rewrite) {
        Expression bodyExpr = (Expression)rewrite.createMoveTarget(lambda.getBody());
        Block blockBody = QuickAssistProcessor.getBlockBodyForLambda(bodyExpr, lambda.resolveMethodBinding().getReturnType(), ast);
        rewrite.set((ASTNode)lambda, (StructuralPropertyDescriptor)LambdaExpression.BODY_PROPERTY, (Object)blockBody, null);
    }

    private static Block getBlockBodyForLambda(Expression bodyExpr, ITypeBinding returnTypeBinding, AST ast) {
        ExpressionStatement statementInBlockBody;
        if (ast.resolveWellKnownType("void").isEqualTo((IBinding)returnTypeBinding)) {
            ExpressionStatement expressionStatement;
            statementInBlockBody = expressionStatement = ast.newExpressionStatement(bodyExpr);
        } else {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(bodyExpr);
            statementInBlockBody = returnStatement;
        }
        Block blockBody = ast.newBlock();
        blockBody.statements().add(statementInBlockBody);
        return blockBody;
    }

    public static boolean getCatchClauseToThrowsProposals(IInvocationContext context, ASTNode node, Collection<CUCorrectionProposal> resultingCollections) {
        ASTRewriteCorrectionProposal proposal;
        String label;
        if (resultingCollections == null) {
            return true;
        }
        CatchClause catchClause = (CatchClause)ASTResolving.findAncestor((ASTNode)node, (int)12);
        if (catchClause == null) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement((ASTNode)node);
        if (statement != catchClause.getParent() && statement != catchClause.getBody()) {
            return false;
        }
        Type type = catchClause.getException().getType();
        if (!(type.isSimpleType() || type.isUnionType() || type.isNameQualifiedType())) {
            return false;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)catchClause);
        if (!(bodyDeclaration instanceof MethodDeclaration) && !(bodyDeclaration instanceof Initializer)) {
            return false;
        }
        AST ast = bodyDeclaration.getAST();
        SimpleType selectedMultiCatchType = null;
        if (type.isUnionType() && node instanceof Name) {
            Name topMostName = ASTNodes.getTopMostName((Name)node);
            ASTNode parent = topMostName.getParent();
            if (parent instanceof SimpleType) {
                selectedMultiCatchType = (SimpleType)parent;
            } else if (parent instanceof NameQualifiedType) {
                selectedMultiCatchType = (NameQualifiedType)parent;
            }
        }
        if (bodyDeclaration instanceof MethodDeclaration) {
            String label2;
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            if (selectedMultiCatchType != null) {
                QuickAssistProcessor.removeException(rewrite, (UnionType)type, (Type)selectedMultiCatchType);
                QuickAssistProcessor.addExceptionToThrows(ast, methodDeclaration, rewrite, (Type)selectedMultiCatchType);
                label2 = CorrectionMessages.QuickAssistProcessor_exceptiontothrows_description;
                ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label2, context.getCompilationUnit(), rewrite, 6);
                resultingCollections.add(proposal2);
            } else {
                QuickAssistProcessor.removeCatchBlock(rewrite, catchClause);
                if (type.isUnionType()) {
                    UnionType unionType = (UnionType)type;
                    List types = unionType.types();
                    for (Type elementType : types) {
                        if (!(elementType instanceof SimpleType) && !(elementType instanceof NameQualifiedType)) {
                            return false;
                        }
                        QuickAssistProcessor.addExceptionToThrows(ast, methodDeclaration, rewrite, elementType);
                    }
                } else {
                    QuickAssistProcessor.addExceptionToThrows(ast, methodDeclaration, rewrite, type);
                }
                label2 = CorrectionMessages.QuickAssistProcessor_catchclausetothrows_description;
                ASTRewriteCorrectionProposal proposal3 = new ASTRewriteCorrectionProposal(label2, context.getCompilationUnit(), rewrite, 4);
                resultingCollections.add(proposal3);
            }
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (selectedMultiCatchType != null) {
            QuickAssistProcessor.removeException(rewrite, (UnionType)type, selectedMultiCatchType);
            label = CorrectionMessages.QuickAssistProcessor_removeexception_description;
            proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 6);
            resultingCollections.add(proposal);
        } else {
            QuickAssistProcessor.removeCatchBlock(rewrite, catchClause);
            label = CorrectionMessages.QuickAssistProcessor_removecatchclause_description;
            proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 5);
            resultingCollections.add(proposal);
        }
        return true;
    }

    private static void removeException(ASTRewrite rewrite, UnionType unionType, Type exception) {
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)unionType, UnionType.TYPES_PROPERTY);
        List types = unionType.types();
        for (Type type : types) {
            if (!type.equals((Object)exception)) continue;
            listRewrite.remove((ASTNode)type, null);
        }
    }

    private static void addExceptionToThrows(AST ast, MethodDeclaration methodDeclaration, ASTRewrite rewrite, Type type2) {
        ITypeBinding binding = type2.resolveBinding();
        if (binding == null || QuickAssistProcessor.isNotYetThrown(binding, methodDeclaration.thrownExceptionTypes())) {
            Type newType = (Type)ASTNode.copySubtree((AST)ast, (ASTNode)type2);
            ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY);
            listRewriter.insertLast((ASTNode)newType, null);
        }
    }

    private static void removeCatchBlock(ASTRewrite rewrite, CatchClause catchClause) {
        TryStatement tryStatement = (TryStatement)catchClause.getParent();
        if (tryStatement.catchClauses().size() > 1 || tryStatement.getFinally() != null || !tryStatement.resources().isEmpty()) {
            rewrite.remove((ASTNode)catchClause, null);
        } else {
            Block block = tryStatement.getBody();
            List statements = block.statements();
            int nStatements = statements.size();
            if (nStatements == 1) {
                ASTNode first = (ASTNode)statements.get(0);
                rewrite.replace((ASTNode)tryStatement, rewrite.createCopyTarget(first), null);
            } else if (nStatements > 1) {
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                ASTNode first = (ASTNode)statements.get(0);
                ASTNode last = (ASTNode)statements.get(statements.size() - 1);
                ASTNode newStatement = listRewrite.createCopyTarget(first, last);
                if (ASTNodes.isControlStatementBody(tryStatement.getLocationInParent())) {
                    Block newBlock = rewrite.getAST().newBlock();
                    newBlock.statements().add(newStatement);
                    newStatement = newBlock;
                }
                rewrite.replace((ASTNode)tryStatement, newStatement, null);
            } else {
                rewrite.remove((ASTNode)tryStatement, null);
            }
        }
    }

    private static boolean isNotYetThrown(ITypeBinding binding, List<Type> thrownExceptions) {
        for (Type thrownException : thrownExceptions) {
            ITypeBinding elem = thrownException.resolveBinding();
            if (elem == null || !Bindings.isSuperType(elem, binding)) continue;
            return false;
        }
        return true;
    }
}

