/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.preferences;

import java.util.Hashtable;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.StatusFactory;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.ls.core.internal.preferences.ClientPreferences;
import org.eclipse.jdt.ls.core.internal.preferences.IPreferencesChangeListener;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;

public class PreferenceManager {
    private Preferences preferences = new Preferences();
    private ClientPreferences clientPreferences;
    private IMavenConfiguration mavenConfig;
    private ListenerList<IPreferencesChangeListener> preferencesChangeListeners = new ListenerList();

    public PreferenceManager() {
        this.initialize();
    }

    public void initialize() {
        Hashtable javaCoreOptions = JavaCore.getOptions();
        javaCoreOptions.put("org.eclipse.jdt.core.codeComplete.visibilityCheck", "enabled");
        javaCoreOptions.put("org.eclipse.jdt.core.formatter.use_on_off_tags", "true");
        JavaCore.setOptions((Hashtable)javaCoreOptions);
    }

    public void update(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences can not be null");
        }
        this.preferencesChanged(this.preferences, preferences);
        this.preferences = preferences;
        String newMavenSettings = preferences.getMavenUserSettings();
        String oldMavenSettings = this.getMavenConfiguration().getUserSettingsFile();
        if (!Objects.equals(newMavenSettings, oldMavenSettings)) {
            try {
                this.getMavenConfiguration().setUserSettingsFile(newMavenSettings);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("failed to set Maven settings", e);
                preferences.setMavenUserSettings(oldMavenSettings);
            }
        }
    }

    private void preferencesChanged(final Preferences oldPreferences, final Preferences newPreferences) {
        for (final IPreferencesChangeListener listener : this.preferencesChangeListeners) {
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable e) {
                    JavaLanguageServerPlugin.log(new CoreException(StatusFactory.newErrorStatus(e.getMessage(), e)));
                }

                public void run() throws Exception {
                    listener.preferencesChange(oldPreferences, newPreferences);
                }
            };
            SafeRunner.run((ISafeRunnable)job);
        }
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public Preferences getPreferences(IResource resource) {
        return this.preferences;
    }

    public ClientPreferences getClientPreferences() {
        return this.clientPreferences;
    }

    public void updateClientPrefences(ClientCapabilities clientCapabilities) {
        this.clientPreferences = new ClientPreferences(clientCapabilities);
    }

    public IMavenConfiguration getMavenConfiguration() {
        if (this.mavenConfig == null) {
            this.mavenConfig = MavenPlugin.getMavenConfiguration();
        }
        return this.mavenConfig;
    }

    public void setMavenConfiguration(IMavenConfiguration mavenConfig) {
        this.mavenConfig = mavenConfig;
    }

    public static Preferences getPrefs(IResource resource) {
        return JavaLanguageServerPlugin.getPreferencesManager().getPreferences(resource);
    }

    public static CodeGenerationSettings getCodeGenerationSettings(IResource resource) {
        IJavaProject project = JavaCore.create((IProject)resource.getProject());
        CodeGenerationSettings res = new CodeGenerationSettings();
        res.tabWidth = CodeFormatterUtil.getTabWidth((IJavaProject)project);
        res.indentWidth = CodeFormatterUtil.getIndentWidth((IJavaProject)project);
        return res;
    }

    public void addPreferencesChangeListener(IPreferencesChangeListener listener) {
        this.preferencesChangeListeners.add((Object)listener);
    }

    public void removePreferencesChangeListener(IPreferencesChangeListener listener) {
        this.preferencesChangeListeners.remove((Object)listener);
    }
}

