/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jdt.ls.core.internal.ActionableNotification;
import org.eclipse.jdt.ls.core.internal.IProjectImporter;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;
import org.eclipse.jdt.ls.core.internal.StatusFactory;
import org.eclipse.jdt.ls.core.internal.managers.GradleBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.MavenBuildSupport;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.TextDocumentIdentifier;

public class ProjectsManager
implements ISaveParticipant {
    public static final String DEFAULT_PROJECT_NAME = "jdt.ls-java-project";
    private PreferenceManager preferenceManager;
    private JavaClientConnection.JavaLanguageClient client;

    public ProjectsManager(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public void initializeProjects(final Collection<IPath> rootPaths, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        JavaCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ProjectsManager.this.deleteInvalidProjects(rootPaths, (IProgressMonitor)subMonitor.split(10));
                GradleBuildSupport.cleanGradleModels((IProgressMonitor)subMonitor.split(10));
                ProjectsManager.this.createJavaProject(ProjectsManager.this.getDefaultProject(), (IProgressMonitor)subMonitor.split(10));
                ProjectsManager.this.importProjects(rootPaths, (IProgressMonitor)subMonitor.split(70));
                subMonitor.done();
            }
        }, (IProgressMonitor)monitor);
    }

    private void importProjects(Collection<IPath> rootPaths, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(rootPaths.size() * 100));
        for (IPath rootPath : rootPaths) {
            File rootFolder = rootPath.toFile();
            IProjectImporter importer = this.getImporter(rootFolder, (IProgressMonitor)subMonitor.split(30));
            if (importer == null) continue;
            importer.importToWorkspace((IProgressMonitor)subMonitor.split(70));
        }
    }

    public Job updateWorkspaceFolders(final Collection<IPath> addedRootPaths, final Collection<IPath> removedRootPaths) {
        JavaLanguageServerPlugin.sendStatus(ServiceStatus.Message, "Updating workspace folders: Adding " + addedRootPaths.size() + " folder(s), removing " + removedRootPaths.size() + " folders.");
        WorkspaceJob job = new WorkspaceJob("Updating workspace folders"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(addedRootPaths.size() + removedRootPaths.size()));
                try {
                    IProject[] projects;
                    long start = System.currentTimeMillis();
                    IProject[] iProjectArray = projects = ProjectsManager.getWorkspaceRoot().getProjects();
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        if (ResourceUtils.isContainedIn(project.getLocation(), removedRootPaths)) {
                            try {
                                project.delete(false, true, (IProgressMonitor)subMonitor.split(1));
                            }
                            catch (CoreException e) {
                                JavaLanguageServerPlugin.logException("Problems removing '" + project.getName() + "' from workspace.", e);
                            }
                        }
                        ++n2;
                    }
                    ProjectsManager.this.importProjects(addedRootPaths, (IProgressMonitor)subMonitor.split(addedRootPaths.size()));
                    long elapsed = System.currentTimeMillis() - start;
                    JavaLanguageServerPlugin.logInfo("Updated workspace folders in " + elapsed + " ms: Added " + addedRootPaths.size() + " folder(s), removed" + removedRootPaths.size() + " folders.");
                    JavaLanguageServerPlugin.logInfo(ProjectsManager.this.getWorkspaceInfo());
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    String msg = "Error updating workspace folders";
                    JavaLanguageServerPlugin.logError(msg);
                    status = StatusFactory.newErrorStatus(msg, e);
                    GradleBuildSupport.cleanGradleModels(monitor);
                    return status;
                }
            }
        };
        job.schedule();
        return job;
    }

    private void deleteInvalidProjects(Collection<IPath> rootPaths, IProgressMonitor monitor) {
        IProject[] iProjectArray = ProjectsManager.getWorkspaceRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.exists() && (ResourceUtils.isContainedIn(project.getLocation(), rootPaths) || ProjectUtils.isGradleProject(project))) {
                try {
                    project.getDescription();
                }
                catch (CoreException e) {
                    try {
                        project.delete(true, monitor);
                    }
                    catch (CoreException e1) {
                        JavaLanguageServerPlugin.logException(e1.getMessage(), e1);
                    }
                }
            } else {
                try {
                    project.delete(false, true, monitor);
                }
                catch (CoreException e1) {
                    JavaLanguageServerPlugin.logException(e1.getMessage(), e1);
                }
            }
            ++n2;
        }
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void fileChanged(String uriString, CHANGE_TYPE changeType) {
        block11: {
            if (uriString == null) {
                return;
            }
            IFile resource = JDTUtils.findFile(uriString);
            if (resource == null) {
                return;
            }
            try {
                if (changeType == CHANGE_TYPE.DELETED) {
                    resource = resource.getParent();
                }
                if (resource != null) {
                    resource.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                if (!this.isBuildFile((IResource)resource)) break block11;
                Preferences.FeatureStatus status = this.preferenceManager.getPreferences().getUpdateBuildConfigurationStatus();
                switch (status) {
                    case automatic: {
                        this.updateProject(resource.getProject());
                        break;
                    }
                    case disabled: {
                        break;
                    }
                    default: {
                        if (this.client != null) {
                            String cmd = "java.projectConfiguration.status";
                            TextDocumentIdentifier uri = new TextDocumentIdentifier(uriString);
                            ActionableNotification updateProjectConfigurationNotification = new ActionableNotification().withSeverity(MessageType.Info).withMessage("A build file was modified. Do you want to synchronize the Java classpath/configuration?").withCommands(Arrays.asList(new Command("Never", cmd, Arrays.asList(new Object[]{uri, Preferences.FeatureStatus.disabled})), new Command("Now", cmd, Arrays.asList(new Object[]{uri, Preferences.FeatureStatus.interactive})), new Command("Always", cmd, Arrays.asList(new Object[]{uri, Preferences.FeatureStatus.automatic}))));
                            this.client.sendActionableNotification(updateProjectConfigurationNotification);
                        }
                        break;
                    }
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem refreshing workspace", e);
            }
        }
    }

    public boolean isBuildFile(IResource resource) {
        return this.buildSupports().filter(bs -> bs.isBuildFile(resource)).findAny().isPresent();
    }

    private IProjectImporter getImporter(File rootFolder, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        Collection<IProjectImporter> importers = this.importers();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)importers.size());
        for (IProjectImporter importer : importers) {
            importer.initialize(rootFolder);
            if (!importer.applies((IProgressMonitor)subMonitor.split(1))) continue;
            return importer;
        }
        return null;
    }

    public IProject getDefaultProject() {
        return ProjectsManager.getWorkspaceRoot().getProject(DEFAULT_PROJECT_NAME);
    }

    private Collection<IProjectImporter> importers() {
        TreeMap<Integer, IProjectImporter> importers = new TreeMap<Integer, IProjectImporter>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.ls.core", "importers");
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configs.length) {
            try {
                Integer order = Integer.valueOf(configs[i].getAttribute("order"));
                importers.put(order, (IProjectImporter)configs[i].createExecutableExtension("class"));
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e.getStatus());
            }
            ++i;
        }
        return importers.values();
    }

    public IProject createJavaProject(IProject project, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (project.exists()) {
            return project;
        }
        JavaLanguageServerPlugin.logInfo("Creating the default Java project");
        project.create(monitor);
        project.open(monitor);
        IProjectDescription description = project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        project.setDescription(description, monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IFolder output = project.getFolder("bin");
        if (!output.exists()) {
            output.create(true, true, monitor);
        }
        javaProject.setOutputLocation(output.getFullPath(), monitor);
        IFolder source = project.getFolder("src");
        if (!source.exists()) {
            source.create(true, true, monitor);
        }
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)source);
        IClasspathEntry src = JavaCore.newSourceEntry((IPath)root.getPath());
        IClasspathEntry jre = JavaRuntime.getDefaultJREContainerEntry();
        javaProject.setRawClasspath(new IClasspathEntry[]{jre, src}, monitor);
        JavaLanguageServerPlugin.logInfo("Finished creating the default Java project");
        return project;
    }

    public Job updateProject(final IProject project) {
        if (project == null || !ProjectUtils.isMavenProject(project) && !ProjectUtils.isGradleProject(project)) {
            return null;
        }
        JavaLanguageServerPlugin.sendStatus(ServiceStatus.Message, "Updating " + project.getName() + " configuration");
        WorkspaceJob job = new WorkspaceJob("Update project " + project.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                String projectName = project.getName();
                try {
                    long start = System.currentTimeMillis();
                    Optional buildSupport = ProjectsManager.this.getBuildSupport(project);
                    if (buildSupport.isPresent()) {
                        ((IBuildSupport)buildSupport.get()).update(project, monitor);
                    }
                    long elapsed = System.currentTimeMillis() - start;
                    JavaLanguageServerPlugin.logInfo("Updated " + projectName + " in " + elapsed + " ms");
                }
                catch (CoreException e) {
                    String msg = "Error updating " + projectName;
                    JavaLanguageServerPlugin.logError(msg);
                    status = StatusFactory.newErrorStatus(msg, e);
                }
                return status;
            }
        };
        job.schedule();
        return job;
    }

    private Optional<IBuildSupport> getBuildSupport(IProject project) {
        return this.buildSupports().filter(bs -> bs.applies(project)).findFirst();
    }

    private Stream<IBuildSupport> buildSupports() {
        return Stream.of(new GradleBuildSupport(), new MavenBuildSupport());
    }

    public void setConnection(JavaClientConnection.JavaLanguageClient client) {
        this.client = client;
    }

    private String getWorkspaceInfo() {
        StringBuilder b = new StringBuilder();
        b.append("Projects:\n");
        IProject[] iProjectArray = ProjectsManager.getWorkspaceRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            b.append(project.getName()).append(": ").append(project.getLocation().toOSString()).append('\n');
            if (ProjectUtils.isJavaProject(project)) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                try {
                    IClasspathEntry[] cpEntries;
                    b.append("  resolved classpath:\n");
                    IClasspathEntry[] iClasspathEntryArray = cpEntries = javaProject.getRawClasspath();
                    int n3 = cpEntries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry cpe = iClasspathEntryArray[n4];
                        b.append("  ").append(cpe.getPath().toString()).append('\n');
                        if (cpe.getEntryKind() == 5) {
                            IPackageFragmentRoot[] roots;
                            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.findPackageFragmentRoots(cpe);
                            int n5 = roots.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IPackageFragmentRoot root = iPackageFragmentRootArray[n6];
                                b.append("    ").append(root.getPath().toString()).append('\n');
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                catch (CoreException coreException) {}
            } else {
                b.append("  non-Java project\n");
            }
            ++n2;
        }
        b.append("Java Runtimes:\n");
        IVMInstall defaultVMInstall = JavaRuntime.getDefaultVMInstall();
        b.append("  default: ");
        if (defaultVMInstall != null) {
            b.append(defaultVMInstall.getInstallLocation().toString());
        } else {
            b.append("-");
        }
        IExecutionEnvironmentsManager eem = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] iExecutionEnvironmentArray = eem.getExecutionEnvironments();
        int n7 = iExecutionEnvironmentArray.length;
        int n8 = 0;
        while (n8 < n7) {
            IExecutionEnvironment ee = iExecutionEnvironmentArray[n8];
            IVMInstall[] vms = ee.getCompatibleVMs();
            b.append("  ").append(ee.getDescription()).append(": ");
            if (vms.length > 0) {
                b.append(vms[0].getInstallLocation().toString());
            } else {
                b.append("-");
            }
            b.append("\n");
            ++n8;
        }
        return b.toString();
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
        if (context.getKind() == 1) {
            GradleBuildSupport.saveModels();
        }
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
    }

    public boolean setAutoBuilding(boolean enable) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        boolean changed = description.isAutoBuilding() ^ enable;
        if (changed) {
            description.setAutoBuilding(enable);
            workspace.setDescription(description);
        }
        return changed;
    }

    public static enum CHANGE_TYPE {
        CREATED,
        CHANGED,
        DELETED;

    }
}

