/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;

public final class WorkspaceDiagnosticsHandler
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private final JavaClientConnection connection;
    private final ProjectsManager projectsManager;

    public WorkspaceDiagnosticsHandler(JavaClientConnection connection, ProjectsManager projectsManager) {
        this.connection = connection;
        this.projectsManager = projectsManager;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            delta.accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("failed to send diagnostics", e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource == null || !resource.isAccessible()) {
            return false;
        }
        if (resource.getType() == 2 || resource.getType() == 8) {
            return true;
        }
        if (resource.getType() == 4) {
            return !JavaLanguageServerPlugin.getProjectsManager().getDefaultProject().equals((Object)resource.getProject());
        }
        if ((delta.getFlags() & 0x20000) == 0) {
            return false;
        }
        IFile file = (IFile)resource;
        String uri = JDTUtils.getFileURI(resource);
        IDocument document = null;
        IMarker[] markers = null;
        if (JavaCore.isJavaLikeFileName((String)file.getName())) {
            markers = resource.findMarkers("org.eclipse.jdt.core.problem", false, 1);
            ICompilationUnit cu = (ICompilationUnit)JavaCore.create((IFile)file);
            document = JsonRpcHelpers.toDocument(cu.getBuffer());
        } else if (this.projectsManager.isBuildFile((IResource)file)) {
            markers = file.findMarkers(null, true, 1);
            document = JsonRpcHelpers.toDocument(file);
        }
        if (document != null) {
            this.connection.publishDiagnostics(new PublishDiagnosticsParams(ResourceUtils.toClientUri(uri), WorkspaceDiagnosticsHandler.toDiagnosticsArray(document, markers)));
        }
        return false;
    }

    public static List<Diagnostic> toDiagnosticsArray(IDocument document, IMarker[] markers) {
        List<Diagnostic> diagnostics = Stream.of(markers).map(m -> WorkspaceDiagnosticsHandler.toDiagnostic(document, m)).filter(d -> d != null).collect(Collectors.toList());
        return diagnostics;
    }

    private static Diagnostic toDiagnostic(IDocument document, IMarker marker) {
        if (marker == null || !marker.exists()) {
            return null;
        }
        Diagnostic d = new Diagnostic();
        d.setSource("Java");
        d.setMessage(marker.getAttribute("message", ""));
        d.setCode(String.valueOf(marker.getAttribute("id", 0)));
        d.setSeverity(WorkspaceDiagnosticsHandler.convertSeverity(marker.getAttribute("severity", -1)));
        d.setRange(WorkspaceDiagnosticsHandler.convertRange(document, marker));
        return d;
    }

    private static Range convertRange(IDocument document, IMarker marker) {
        int cEnd;
        int cStart;
        int line;
        block5: {
            line = marker.getAttribute("lineNumber", -1) - 1;
            cStart = 0;
            cEnd = 0;
            try {
                if (marker.isSubtypeOf("org.eclipse.m2e.core.maven2Problem")) {
                    cStart = marker.getAttribute("columnStart", -1);
                    cEnd = marker.getAttribute("columnEnd", -1);
                    break block5;
                }
                int lineOffset = 0;
                try {
                    lineOffset = document.getLineOffset(line);
                }
                catch (BadLocationException unlikelyException) {
                    JavaLanguageServerPlugin.logException(unlikelyException.getMessage(), unlikelyException);
                    return new Range(new Position(line, 0), new Position(line, 0));
                }
                cEnd = marker.getAttribute("charEnd", -1) - lineOffset;
                cStart = marker.getAttribute("charStart", -1) - lineOffset;
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        cStart = Math.max(0, cStart);
        cEnd = Math.max(0, cEnd);
        return new Range(new Position(line, cStart), new Position(line, cEnd));
    }

    private static DiagnosticSeverity convertSeverity(int severity) {
        if (severity == 2) {
            return DiagnosticSeverity.Error;
        }
        if (severity == 1) {
            return DiagnosticSeverity.Warning;
        }
        return DiagnosticSeverity.Information;
    }
}

