/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class JavaRefactoringDescriptorUtil {
    public static final String ATTRIBUTE_ELEMENT = "element";
    public static final String ATTRIBUTE_INPUT = "input";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_REFERENCES = "references";
    public static final String ATTRIBUTE_SELECTION = "selection";

    private JavaRefactoringDescriptorUtil() {
    }

    public static String elementToHandle(String project, IJavaElement element) {
        IJavaProject javaProject;
        String handle = element.getHandleIdentifier();
        if (project != null && !(element instanceof IJavaProject) && project.equals((javaProject = element.getJavaProject()).getElementName())) {
            String id = javaProject.getHandleIdentifier();
            return handle.substring(id.length());
        }
        return handle;
    }

    public static IJavaElement handleToElement(String project, String handle) {
        return JavaRefactoringDescriptorUtil.handleToElement(project, handle, true);
    }

    public static IJavaElement handleToElement(String project, String handle, boolean check) {
        return JavaRefactoringDescriptorUtil.handleToElement(null, project, handle, check);
    }

    public static IJavaElement handleToElement(WorkingCopyOwner owner, String project, String handle, boolean check) {
        IMethod method;
        IMethod[] methods;
        IJavaElement element = null;
        element = owner != null ? JavaCore.create((String)handle, (WorkingCopyOwner)owner) : JavaCore.create((String)handle);
        if (element == null && project != null) {
            IJavaProject javaProject = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProject(project);
            String identifier = javaProject.getHandleIdentifier();
            element = owner != null ? JavaCore.create((String)(String.valueOf(identifier) + handle), (WorkingCopyOwner)owner) : JavaCore.create((String)(String.valueOf(identifier) + handle));
        }
        if (check && element instanceof IMethod && (methods = (method = (IMethod)element).getDeclaringType().findMethods(method)) != null && methods.length > 0) {
            element = methods[0];
        }
        if (element != null && (!check || element.exists())) {
            return element;
        }
        return null;
    }

    public static IResource handleToResource(String project, String handle) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if ("".equals(handle)) {
            return null;
        }
        IPath path = Path.fromPortableString((String)handle);
        if (path == null) {
            return null;
        }
        if (project != null && !"".equals(project) && !path.isAbsolute()) {
            return root.getProject(project).findMember(path);
        }
        return root.findMember(path);
    }

    public static String resourceToHandle(String project, IResource resource) {
        if (project != null && !"".equals(project) && project.equals(resource.getProject().getName())) {
            return resource.getProjectRelativePath().toPortableString();
        }
        return resource.getFullPath().toPortableString();
    }

    public static RefactoringStatus createInputFatalStatus(Object element, String name, String id) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)id);
        if (element != null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_input_not_exists, new String[]{JavaElementLabels.getTextLabel(element, JavaElementLabels.ALL_FULLY_QUALIFIED), name, id}));
        }
        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_inputs_do_not_exist, new String[]{name, id}));
    }

    public static RefactoringStatus createInputWarningStatus(Object element, String name, String id) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)id);
        if (element != null) {
            return RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_input_not_exists, new String[]{JavaElementLabels.getTextLabel(element, JavaElementLabels.ALL_FULLY_QUALIFIED), name, id}));
        }
        return RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_inputs_do_not_exist, new String[]{name, id}));
    }
}

