/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.ls.core.internal.Environment;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public class ConnectionStreamFactory {
    private StreamProvider provider;

    public StreamProvider getSelectedStream() {
        if (this.provider == null) {
            this.provider = this.createProvider();
        }
        return this.provider;
    }

    private StreamProvider createProvider() {
        String host = Environment.get("CLIENT_HOST", "localhost");
        String port = Environment.get("CLIENT_PORT");
        if (port != null) {
            return new SocketStreamProvider(host, Integer.parseInt(port));
        }
        return new StdIOStreamProvider();
    }

    public InputStream getInputStream() throws IOException {
        return this.getSelectedStream().getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getSelectedStream().getOutputStream();
    }

    protected static boolean isWindows() {
        return "win32".equals(Platform.getOS());
    }

    protected final class SocketStreamProvider
    implements StreamProvider {
        private final String host;
        private final int port;
        private InputStream fInputStream;
        private OutputStream fOutputStream;

        public SocketStreamProvider(String host, int port) {
            this.host = host;
            this.port = port;
        }

        private void initializeConnection() throws IOException {
            Socket socket = new Socket(this.host, this.port);
            this.fInputStream = socket.getInputStream();
            this.fOutputStream = socket.getOutputStream();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.fInputStream == null) {
                this.initializeConnection();
            }
            return this.fInputStream;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            if (this.fOutputStream == null) {
                this.initializeConnection();
            }
            return this.fOutputStream;
        }
    }

    protected final class StdIOStreamProvider
    implements StreamProvider {
        protected StdIOStreamProvider() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return JavaLanguageServerPlugin.getIn();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return JavaLanguageServerPlugin.getOut();
        }
    }

    static interface StreamProvider {
        public InputStream getInputStream() throws IOException;

        public OutputStream getOutputStream() throws IOException;
    }
}

