/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

class ComputeProjectOrder {
    private ComputeProjectOrder() {
    }

    static VertexOrder computeVertexOrder(SortedSet<? extends Object> vertexes, List<? extends Object[]> references) {
        Object[][] knots;
        Digraph g1 = new Digraph();
        for (Object e : vertexes) {
            g1.addVertex(e);
        }
        for (Object[] objectArray : references) {
            Object object = objectArray[0];
            Iterator<Object> q = objectArray[1];
            g1.addEdge(q, object);
        }
        g1.freeze();
        Digraph digraph = new Digraph();
        List<Object> resortedVertexes = g1.idsByDFSFinishTime(false);
        for (Object object : resortedVertexes) {
            digraph.addVertex(object);
        }
        for (Object[] objectArray : references) {
            Object p = objectArray[0];
            Object q = objectArray[1];
            digraph.addEdge(p, q);
        }
        digraph.freeze();
        List<Object> list = digraph.idsByDFSFinishTime(true);
        Object[] orderedVertexes = new Object[list.size()];
        list.toArray(orderedVertexes);
        boolean hasCycles = digraph.containsCycles();
        if (hasCycles) {
            List<Object[]> knotList = digraph.nonTrivialComponents();
            knots = new Object[knotList.size()][];
            knotList.toArray((T[])knots);
        } else {
            knots = new Object[][]{};
        }
        return new VertexOrder(orderedVertexes, hasCycles, knots);
    }

    static VertexOrder filterVertexOrder(VertexOrder order, VertexFilter filter) {
        int filteredCount = 0;
        boolean[] filterMatches = new boolean[order.vertexes.length];
        int i = 0;
        while (i < order.vertexes.length) {
            filterMatches[i] = filter.matches(order.vertexes[i]);
            if (filterMatches[i]) {
                ++filteredCount;
            }
            ++i;
        }
        if (filteredCount == 0) {
            return order;
        }
        Object[] reducedVertexes = new Object[order.vertexes.length - filteredCount];
        int i2 = 0;
        int j = 0;
        while (i2 < order.vertexes.length) {
            if (!filterMatches[i2]) {
                reducedVertexes[j] = order.vertexes[i2];
                ++j;
            }
            ++i2;
        }
        ArrayList<Object[]> reducedKnots = new ArrayList<Object[]>(order.knots.length);
        Object[][] objectArray = order.knots;
        int n = order.knots.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] knot = objectArray[n2];
            ArrayList<Object> knotList = new ArrayList<Object>(knot.length);
            Object[] objectArray2 = knot;
            int n3 = knot.length;
            int n4 = 0;
            while (n4 < n3) {
                Object element = objectArray2[n4];
                Object vertex = element;
                if (!filter.matches(vertex)) {
                    knotList.add(vertex);
                }
                ++n4;
            }
            if (knotList.size() > 1) {
                reducedKnots.add(knotList.toArray());
            }
            ++n2;
        }
        return new VertexOrder(reducedVertexes, reducedKnots.size() > 0, (Object[][])reducedKnots.toArray((T[])new Object[reducedKnots.size()][]));
    }

    private static class Digraph {
        private List<Vertex> vertexList = new ArrayList<Vertex>(100);
        private Map<Object, Vertex> vertexMap = new HashMap<Object, Vertex>(100);
        private int time;
        private boolean initialized = false;
        private boolean cycles = false;

        public void freeze() {
            if (!this.initialized) {
                this.initialized = true;
                this.DFS();
            }
        }

        public void addVertex(Object id) throws IllegalArgumentException {
            if (this.initialized) {
                throw new IllegalArgumentException();
            }
            Vertex vertex = new Vertex(id);
            Vertex existing = this.vertexMap.put(id, vertex);
            if (existing != null) {
                throw new IllegalArgumentException();
            }
            this.vertexList.add(vertex);
        }

        public void addEdge(Object fromId, Object toId) throws IllegalArgumentException {
            if (this.initialized) {
                throw new IllegalArgumentException();
            }
            Vertex fromVertex = this.vertexMap.get(fromId);
            Vertex toVertex = this.vertexMap.get(toId);
            if (fromVertex == null) {
                throw new IllegalArgumentException();
            }
            if (toVertex == null) {
                throw new IllegalArgumentException();
            }
            fromVertex.adjacent.add(toVertex);
        }

        public List<Object> idsByDFSFinishTime(boolean increasing) {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            int len = this.vertexList.size();
            Object[] r = new Object[len];
            for (Vertex vertex : this.vertexList) {
                int f = vertex.finishTime;
                if (increasing) {
                    r[f - 1] = vertex.id;
                    continue;
                }
                r[len - f] = vertex.id;
            }
            return Arrays.asList(r);
        }

        public boolean containsCycles() {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            return this.cycles;
        }

        public List<Object[]> nonTrivialComponents() {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            HashMap<Vertex, ArrayList<Object>> components = new HashMap<Vertex, ArrayList<Object>>();
            for (Vertex vertex : this.vertexList) {
                if (vertex.predecessor == null) continue;
                Vertex root = vertex;
                while (root.predecessor != null) {
                    root = root.predecessor;
                }
                ArrayList<Object> component = (ArrayList<Object>)components.get(root);
                if (component == null) {
                    component = new ArrayList<Object>(2);
                    component.add(root.id);
                    components.put(root, component);
                }
                component.add(vertex.id);
            }
            ArrayList<Object[]> result = new ArrayList<Object[]>(components.size());
            for (List component : components.values()) {
                if (component.size() <= 1) continue;
                result.add(component.toArray());
            }
            return result;
        }

        private void DFS() {
            Integer NEXT_VERTEX_OBJECT = 1;
            Integer AFTER_NEXTED_DFS_VISIT_OBJECT = 4;
            this.time = 0;
            ArrayList<Object> stack = new ArrayList<Object>(Math.max(1, this.vertexList.size()));
            Iterator allAdjacent = null;
            Vertex vertex = null;
            Iterator<Vertex> allV = this.vertexList.iterator();
            int state = 1;
            block6: while (true) {
                switch (state) {
                    case 1: {
                        if (!allV.hasNext()) break block6;
                        Vertex nextVertex = allV.next();
                        if (nextVertex.color == "white") {
                            stack.add(NEXT_VERTEX_OBJECT);
                            vertex = nextVertex;
                            state = 2;
                            continue block6;
                        }
                        state = 1;
                        continue block6;
                    }
                    case 2: {
                        vertex.color = "grey";
                        allAdjacent = vertex.adjacent.iterator();
                        state = 3;
                        continue block6;
                    }
                    case 3: {
                        if (allAdjacent.hasNext()) {
                            Vertex adjVertex = (Vertex)allAdjacent.next();
                            if (adjVertex.color == "white") {
                                adjVertex.predecessor = vertex;
                                stack.add(allAdjacent);
                                stack.add(vertex);
                                stack.add(AFTER_NEXTED_DFS_VISIT_OBJECT);
                                vertex = adjVertex;
                                state = 2;
                                continue block6;
                            }
                            if (adjVertex.color == "grey") {
                                this.cycles = true;
                            }
                            state = 3;
                            continue block6;
                        }
                        vertex.color = "black";
                        vertex.finishTime = ++this.time;
                        state = (Integer)stack.remove(stack.size() - 1);
                        continue block6;
                    }
                    case 4: {
                        vertex = (Vertex)stack.remove(stack.size() - 1);
                        allAdjacent = (Iterator)stack.remove(stack.size() - 1);
                        state = 3;
                    }
                    default: {
                        continue block6;
                    }
                }
                break;
            }
        }

        public static class Vertex {
            public static final String WHITE = "white";
            public static final String GREY = "grey";
            public static final String BLACK = "black";
            public String color = "white";
            public Vertex predecessor = null;
            public int finishTime;
            public Object id;
            public List<Vertex> adjacent = new ArrayList<Vertex>(3);

            public Vertex(Object id) {
                this.id = id;
            }
        }
    }

    static interface VertexFilter {
        public boolean matches(Object var1);
    }

    static final class VertexOrder {
        public Object[] vertexes;
        public boolean hasCycles;
        public Object[][] knots;

        public VertexOrder(Object[] vertexes, boolean hasCycles, Object[][] knots) {
            this.vertexes = vertexes;
            this.hasCycles = hasCycles;
            this.knots = knots;
        }
    }
}

