/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.lang.reflect.InvocationTargetException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.osgi.util.function.Consumer;
import org.osgi.util.function.Function;
import org.osgi.util.function.Predicate;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.promise.PromiseImpl;
import org.osgi.util.promise.Success;

final class DeferredPromiseImpl<T>
extends PromiseImpl<T> {
    private final CountDownLatch resolved = new CountDownLatch(1);
    private T value;
    private Throwable fail;

    DeferredPromiseImpl(PromiseFactory factory) {
        super(factory);
    }

    @Override
    public boolean isDone() {
        return this.resolved.getCount() == 0L;
    }

    @Override
    public T getValue() throws InvocationTargetException, InterruptedException {
        this.resolved.await();
        if (this.fail == null) {
            return this.value;
        }
        throw new InvocationTargetException(this.fail);
    }

    @Override
    public Throwable getFailure() throws InterruptedException {
        this.resolved.await();
        return this.fail;
    }

    @Override
    PromiseImpl.Result<T> collect() {
        if (!this.isDone()) {
            return new PromiseImpl.Result((Throwable)((Object)new AssertionError((Object)"promise not resolved")));
        }
        if (this.fail == null) {
            return new PromiseImpl.Result<T>(this.value);
        }
        return new PromiseImpl.Result(this.fail);
    }

    public String toString() {
        if (!this.isDone()) {
            return String.valueOf(super.toString()) + "[unresolved]";
        }
        if (this.fail == null) {
            return String.valueOf(super.toString()) + "[resolved: " + this.value + "]";
        }
        return String.valueOf(super.toString()) + "[failed: " + this.fail + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryResolve(T v, Throwable f) {
        CountDownLatch countDownLatch = this.resolved;
        synchronized (countDownLatch) {
            block6: {
                if (!this.isDone()) break block6;
                return false;
            }
            if (f == null) {
                this.value = v;
            } else {
                this.fail = f;
            }
            this.resolved.countDown();
        }
        this.notifyCallbacks();
        return true;
    }

    void resolve(T v, Throwable f) {
        if (!this.tryResolve(v, f)) {
            throw new IllegalStateException("Already resolved");
        }
    }

    Promise<Void> resolveWith(Promise<? extends T> with) {
        DeferredPromiseImpl<Void> chained;
        DeferredPromiseImpl<Void> deferredPromiseImpl = chained = this.deferred();
        deferredPromiseImpl.getClass();
        with.onResolve(deferredPromiseImpl.new ResolveWith<T>(this, with));
        return chained;
    }

    private final class Chain
    implements Runnable {
        private final Promise<? extends T> promise;

        Chain(Promise<? extends T> promise) {
            this.promise = promise;
        }

        @Override
        public void run() {
            PromiseImpl.Result result = DeferredPromiseImpl.collect(this.promise);
            DeferredPromiseImpl.this.tryResolve(result.value, result.fail);
        }
    }

    final class ChainImpl
    implements Runnable {
        private final PromiseImpl<T> promise;

        ChainImpl(PromiseImpl<T> promise) {
            this.promise = promise;
        }

        @Override
        public void run() {
            PromiseImpl.Result result = this.promise.collect();
            DeferredPromiseImpl.this.tryResolve(result.value, result.fail);
        }
    }

    private final class FallbackChain
    implements Runnable {
        private final Promise<? extends T> fallback;
        private final Throwable failure;

        FallbackChain(Promise<? extends T> fallback, Throwable failure) {
            this.fallback = fallback;
            this.failure = failure;
        }

        @Override
        public void run() {
            PromiseImpl.Result result = DeferredPromiseImpl.collect(this.fallback);
            if (result.fail != null) {
                result.fail = this.failure;
            }
            DeferredPromiseImpl.this.tryResolve(result.value, result.fail);
        }
    }

    final class FallbackTo
    implements Runnable {
        private final PromiseImpl<T> promise;
        private final Promise<? extends T> fallback;

        FallbackTo(PromiseImpl<T> promise, Promise<? extends T> fallback) {
            this.promise = promise;
            this.fallback = Objects.requireNonNull(fallback);
        }

        @Override
        public void run() {
            PromiseImpl.Result result = this.promise.collect();
            if (result.fail != null) {
                this.fallback.onResolve(new FallbackChain(this.fallback, result.fail));
                return;
            }
            DeferredPromiseImpl.this.tryResolve(result.value, null);
        }
    }

    final class Filter
    implements Runnable {
        private final PromiseImpl<T> promise;
        private final Predicate<? super T> predicate;

        Filter(PromiseImpl<T> promise, Predicate<? super T> predicate) {
            this.promise = promise;
            this.predicate = Objects.requireNonNull(predicate);
        }

        @Override
        public void run() {
            PromiseImpl.Result result = this.promise.collect();
            if (result.fail == null) {
                try {
                    if (!this.predicate.test(result.value)) {
                        result.fail = new NoSuchElementException();
                    }
                }
                catch (Throwable e) {
                    result.fail = e;
                }
            }
            DeferredPromiseImpl.this.tryResolve(result.value, result.fail);
        }
    }

    final class FlatMap<P>
    implements Runnable {
        private final PromiseImpl<P> promise;
        private final Function<? super P, Promise<? extends T>> mapper;

        FlatMap(PromiseImpl<P> promise, Function<? super P, Promise<? extends T>> mapper) {
            this.promise = promise;
            this.mapper = Objects.requireNonNull(mapper);
        }

        @Override
        public void run() {
            PromiseImpl.Result<P> result = this.promise.collect();
            if (result.fail == null) {
                Promise flatmap = null;
                try {
                    flatmap = this.mapper.apply(result.value);
                }
                catch (Throwable e) {
                    result.fail = e;
                }
                if (flatmap != null) {
                    flatmap.onResolve(new Chain(flatmap));
                    return;
                }
            }
            DeferredPromiseImpl.this.tryResolve(null, result.fail);
        }
    }

    final class Map<P>
    implements Runnable {
        private final PromiseImpl<P> promise;
        private final Function<? super P, ? extends T> mapper;

        Map(PromiseImpl<P> promise, Function<? super P, ? extends T> mapper) {
            this.promise = promise;
            this.mapper = Objects.requireNonNull(mapper);
        }

        @Override
        public void run() {
            PromiseImpl.Result<P> result = this.promise.collect();
            Object v = null;
            if (result.fail == null) {
                try {
                    v = this.mapper.apply(result.value);
                }
                catch (Throwable e) {
                    result.fail = e;
                }
            }
            DeferredPromiseImpl.this.tryResolve(v, result.fail);
        }
    }

    final class Recover
    implements Runnable {
        private final PromiseImpl<T> promise;
        private final Function<Promise<?>, ? extends T> recovery;

        Recover(PromiseImpl<T> promise, Function<Promise<?>, ? extends T> recovery) {
            this.promise = promise;
            this.recovery = Objects.requireNonNull(recovery);
        }

        @Override
        public void run() {
            PromiseImpl.Result result = this.promise.collect();
            if (result.fail != null) {
                try {
                    Object v = this.recovery.apply(this.promise);
                    if (v != null) {
                        result.value = v;
                        result.fail = null;
                    }
                }
                catch (Throwable e) {
                    result.fail = e;
                }
            }
            DeferredPromiseImpl.this.tryResolve(result.value, result.fail);
        }
    }

    final class RecoverWith
    implements Runnable {
        private final PromiseImpl<T> promise;
        private final Function<Promise<?>, Promise<? extends T>> recovery;

        RecoverWith(PromiseImpl<T> promise, Function<Promise<?>, Promise<? extends T>> recovery) {
            this.promise = promise;
            this.recovery = Objects.requireNonNull(recovery);
        }

        @Override
        public void run() {
            PromiseImpl.Result result = this.promise.collect();
            if (result.fail != null) {
                Promise recovered = null;
                try {
                    recovered = this.recovery.apply(this.promise);
                }
                catch (Throwable e) {
                    result.fail = e;
                }
                if (recovered != null) {
                    recovered.onResolve(new Chain(recovered));
                    return;
                }
            }
            DeferredPromiseImpl.this.tryResolve(result.value, result.fail);
        }
    }

    private final class ResolveWith<P>
    implements Runnable {
        private final DeferredPromiseImpl<P> promise;
        private final Promise<? extends P> with;

        ResolveWith(DeferredPromiseImpl<P> promise, Promise<? extends P> with) {
            this.promise = promise;
            this.with = Objects.requireNonNull(with);
        }

        @Override
        public void run() {
            Throwable f = null;
            PromiseImpl.Result<? extends P> result = DeferredPromiseImpl.collect(this.with);
            try {
                this.promise.resolve(result.value, result.fail);
            }
            catch (Throwable e) {
                f = e;
            }
            DeferredPromiseImpl.this.tryResolve(null, f);
        }
    }

    final class Submit
    implements Runnable {
        private final Callable<? extends T> task;

        Submit(Callable<? extends T> task) {
            this.task = Objects.requireNonNull(task);
        }

        @Override
        public void run() {
            try {
                DeferredPromiseImpl.this.tryResolve(this.task.call(), null);
            }
            catch (Throwable t) {
                DeferredPromiseImpl.this.tryResolve(null, t);
            }
        }
    }

    final class Then<P>
    implements Runnable {
        private final PromiseImpl<P> promise;
        private final Success<P, ? extends T> success;
        private final Failure failure;

        Then(PromiseImpl<P> promise, Success<? super P, ? extends T> success, Failure failure) {
            this.promise = promise;
            this.success = success;
            this.failure = failure;
        }

        @Override
        public void run() {
            PromiseImpl.Result<P> result = this.promise.collect();
            if (result.fail != null) {
                if (this.failure != null) {
                    try {
                        this.failure.fail(this.promise);
                    }
                    catch (Throwable e) {
                        result.fail = e;
                    }
                }
            } else if (this.success != null) {
                Promise returned = null;
                try {
                    returned = this.success.call(this.promise);
                }
                catch (Throwable e) {
                    result.fail = e;
                }
                if (returned != null) {
                    returned.onResolve(new Chain(returned));
                    return;
                }
            }
            DeferredPromiseImpl.this.tryResolve(null, result.fail);
        }
    }

    final class ThenAccept
    implements Runnable {
        private final PromiseImpl<T> promise;
        private final Consumer<? super T> consumer;

        ThenAccept(PromiseImpl<T> promise, Consumer<? super T> consumer) {
            this.promise = promise;
            this.consumer = Objects.requireNonNull(consumer);
        }

        @Override
        public void run() {
            PromiseImpl.Result result = this.promise.collect();
            if (result.fail == null) {
                try {
                    this.consumer.accept(result.value);
                }
                catch (Throwable e) {
                    result.fail = e;
                }
            }
            DeferredPromiseImpl.this.tryResolve(result.value, result.fail);
        }
    }
}

