/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._short.enumeration.enumeration_1;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class enumeration1_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        enumeration1_ValidateCTTests test = new enumeration1_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final short[] validValues = {(short)6154, (short)-63, (short)-74, (short)474, (short)75, (short)-7, 
                                 (short)-4, (short)8, (short)604, (short)2, (short)-69, (short)613, (short)-77,
                                 (short)689, (short)-262, (short)77, (short)-6262, (short)-54, (short)-37};
    final short[] invalidValues = {(short)32767, (short)-32768, (short)0, (short)-75, (short)-222, (short)222};
    
    JAXBElement<Short> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Validate001( ) {
        String xmlDocName = "enumeration-1-1.xml";
        elemObj = (JAXBElement<Short>)unmarshal(xmlDocName);
        return testValid();
    }

    public Status Validate002( ) {
        String xmlDocName = "enumeration-1-1.xml";
        elemObj = (JAXBElement<Short>)unmarshal(xmlDocName);
        return testInvalid();
    }

    public Status Validate003( ) {
        elemObj = (JAXBElement<Short>)(new ObjectFactory()).createNISTSchemaShortEnumeration1((short)-69);
        
        return testValid();
    }

    public Status Validate004( ) {
        elemObj = (JAXBElement<Short>)(new ObjectFactory()).createNISTSchemaShortEnumeration1((short)-69);
        
        return testInvalid();
    }


}

