/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.PongMessage;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.nio.ByteBuffer;

@ServerEndpoint(value="/client")
public class WSCOtherSideServer {
    private static final System.Logger logger = System.getLogger(WSCOtherSideServer.class.getName());

    @OnMessage
    public String onMessage(PongMessage pong) {
        return IOUtil.byteBufferToString(pong.getApplicationData());
    }

    @OnMessage
    public String onMessage(String msg) {
        return msg;
    }

    @OnMessage
    public String onMessage(ByteBuffer buffer) {
        String msg = IOUtil.byteBufferToString(buffer);
        return this.onMessage(msg);
    }

    @OnError
    public void onError(Session session, Throwable t) throws IOException {
        logger.log(System.Logger.Level.INFO, "@OnError in " + this.getClass().getName());
        t.printStackTrace();
        String message = "Exception: " + IOUtil.printStackTrace(t);
        session.getBasicRemote().sendText(message);
    }
}

