/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.common.client;

import com.sun.ts.tests.websocket.common.client.EndpointCallback;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.client.WebSocketTestCase;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class ClientEndpoint<T>
extends Endpoint
implements MessageHandler.Whole<T> {
    public void onOpen(Session session, EndpointConfig config) {
        this.onOpen(session, config, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(Session session, EndpointConfig config, boolean addMessageHandler) {
        WebSocketCommonClient.logTrace("On open on session id", session.getId());
        String uri = session.getRequestURI() == null ? "NULL" : session.getRequestURI().toASCIIString();
        WebSocketCommonClient.logTrace("RequestUri:", uri);
        if (session.isOpen()) {
            if (addMessageHandler) {
                session.addMessageHandler((MessageHandler)this);
            }
        } else {
            WebSocketCommonClient.logTrace("Session is closed!!!!", "");
        }
        Object object = ClientEndpointData.LOCK;
        synchronized (object) {
            if (ClientEndpointData.callback != null && session.isOpen()) {
                ClientEndpointData.callback.onOpen(session, config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Session session, Throwable t) {
        ClientEndpointData.setError(t);
        t.printStackTrace();
        Object object = ClientEndpointData.LOCK;
        synchronized (object) {
            if (ClientEndpointData.callback != null) {
                ClientEndpointData.callback.onError(session, t);
            }
        }
    }

    protected void appendMessage(T message) {
        ClientEndpointData.sb.append(message.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(T message) {
        ClientEndpointData.setOriginalMessage(message);
        this.appendMessage(message);
        WebSocketCommonClient.logTrace("Received message so far", ClientEndpointData.sb.toString());
        Object object = ClientEndpointData.LOCK;
        synchronized (object) {
            if (ClientEndpointData.callback != null) {
                ClientEndpointData.callback.onMessage(message);
            }
        }
        WebSocketTestCase.logTrace("CountDownLatch hit");
        if (ClientEndpointData.messageLatch.getCount() == 0L) {
            throw new IllegalStateException("CountDownLatch.getCount == 0 already");
        }
        ClientEndpointData.messageLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(Session session, CloseReason closeReason) {
        Object object = ClientEndpointData.LOCK;
        synchronized (object) {
            WebSocketTestCase.logTrace("On close on session id", session.getId(), "reason", closeReason);
            if (ClientEndpointData.lastMessage == null) {
                WebSocketTestCase.logTrace("onClose has been called before a message was received");
            } else {
                WebSocketTestCase.logTrace("onClose has been called");
            }
            if (ClientEndpointData.callback != null) {
                ClientEndpointData.callback.onClose(session, closeReason);
            }
            if (ClientEndpointData.onCloseLatch == null) {
                ClientEndpointData.newOnCloseCountDown();
            }
            ClientEndpointData.onCloseLatch.countDown();
        }
    }

    public static CountDownLatch getCountDownLatch() {
        return ClientEndpointData.messageLatch;
    }

    public static StringBuffer getMessageBuilder() {
        return ClientEndpointData.sb;
    }

    public T getLastMessage(Class<T> messageType) {
        return (T)ClientEndpointData.lastMessage;
    }

    public static Throwable getLastError() {
        return ClientEndpointData.websocketError;
    }

    public static class ClientEndpointData {
        protected static volatile StringBuffer sb = new StringBuffer();
        protected static volatile Throwable websocketError = null;
        protected static EndpointCallback callback;
        protected static volatile CountDownLatch messageLatch;
        protected static volatile Object lastMessage;
        protected static final Object LOCK;
        protected static volatile CountDownLatch onCloseLatch;

        public static Throwable getError() {
            return websocketError;
        }

        private static void setError(Throwable error) {
            websocketError = error;
        }

        public static String getResponseAsString() {
            WebSocketTestCase.logMsg("Response:", sb.toString());
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void resetData() {
            Object object = LOCK;
            synchronized (object) {
                WebSocketCommonClient.logTrace("Reseting callback and message", "");
                sb = new StringBuffer();
                websocketError = null;
                callback = null;
                lastMessage = null;
                messageLatch = null;
                onCloseLatch = null;
            }
        }

        public static void newCountDown(int count) {
            messageLatch = new CountDownLatch(count);
        }

        public static void awaitCountDown(int seconds) {
            try {
                messageLatch.await(seconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public static void newOnCloseCountDown() {
            if (onCloseLatch == null) {
                onCloseLatch = new CountDownLatch(1);
            }
        }

        public static long getCount() {
            return messageLatch.getCount();
        }

        public static void awaitOnClose() {
            try {
                onCloseLatch.await(2000L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public static Object getOriginalMessage() {
            return lastMessage;
        }

        private static void setOriginalMessage(Object message) {
            lastMessage = message;
        }

        static {
            lastMessage = null;
            LOCK = new Object();
            onCloseLatch = null;
        }
    }
}

