/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.util.Map;

public abstract class StringQuestion
extends Question {
    protected String value;
    protected String[] suggestions;
    protected int nominalMaxLength;
    private String defaultValue;

    protected StringQuestion(Interview interview, String tag) {
        super(interview, tag);
        this.clear();
        this.setDefaultValue(this.value);
    }

    protected static boolean equal(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String v) {
        this.defaultValue = v;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newValue) {
        String oldValue = this.value;
        String string = this.value = newValue == null ? null : newValue.trim();
        if (!StringQuestion.equal(this.value, oldValue)) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public String getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public boolean isValueValid() {
        return true;
    }

    @Override
    public boolean isValueAlwaysValid() {
        return false;
    }

    public int getNominalMaxLength() {
        return this.nominalMaxLength;
    }

    public void setNominalMaxLength(int nominalMaxLength) {
        this.nominalMaxLength = nominalMaxLength;
    }

    public String[] getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(String ... newSuggestions) {
        if (newSuggestions != null) {
            for (String newSuggestion : newSuggestions) {
                if (newSuggestion != null) continue;
                throw new IllegalArgumentException();
            }
        }
        this.suggestions = newSuggestions;
    }

    @Override
    public void clear() {
        this.setValue(this.defaultValue);
    }

    @Override
    protected void save(Map<String, String> data) {
        if (this.value != null) {
            data.put(this.tag, this.value);
        }
    }
}

