/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class VerboseCommand
extends Command {
    private static final String DEFAULT = "default";
    private static final String MAX = "max";
    private static final String QUIET = "quiet";
    private static final String DATE = "date";
    private static final String NO_PREFIX = "no-";
    private static final String CMD = "verbose";
    private static Map<String, HelpTree.Node> allOptions;
    private static I18NResourceBundle i18n;
    private Map<String, Boolean> optionValues = new HashMap<String, Boolean>();

    VerboseCommand(String cmd) throws Command.Fault {
        super(cmd);
        int chop = cmd.indexOf(CMD);
        if (chop == -1) {
            throw new IllegalArgumentException();
        }
        String workstr = cmd.substring(chop + CMD.length());
        if (workstr.isEmpty()) {
            this.optionValues.put(DEFAULT, Boolean.TRUE);
        } else if (workstr.charAt(0) == ':') {
            workstr = workstr.substring(1);
            this.processOptions(workstr);
        } else {
            throw new Command.Fault(i18n, "verb.badOpts");
        }
    }

    public static void addOption(String name, HelpTree.Node node) {
        VerboseCommand.ensureAllOptionsInitialized();
        allOptions.put(name, node);
    }

    private static void ensureAllOptionsInitialized() {
        if (allOptions == null) {
            allOptions = new TreeMap<String, HelpTree.Node>();
            allOptions.put(MAX, new HelpTree.Node(i18n, "verb.max"));
            allOptions.put(QUIET, new HelpTree.Node(i18n, "verb.quiet"));
        }
    }

    static HelpTree.Node getHelp() {
        VerboseCommand.ensureAllOptionsInitialized();
        HelpTree.Node[] nodes = new HelpTree.Node[allOptions.size()];
        int i = 0;
        for (HelpTree.Node node : allOptions.values()) {
            nodes[i++] = node;
        }
        return new HelpTree.Node(i18n, "verb", nodes);
    }

    static String getName() {
        return CMD;
    }

    private void processOptions(String ops) throws Command.Fault {
        VerboseCommand.ensureAllOptionsInitialized();
        String[] items = StringArray.splitList(ops, ",");
        if (items == null) {
            throw new Command.Fault(i18n, "verb.noOpts");
        }
        for (String item1 : items) {
            boolean on;
            String item = item1;
            if (item.startsWith(NO_PREFIX)) {
                on = false;
                item = item.substring(NO_PREFIX.length());
            } else {
                on = true;
            }
            if (!allOptions.containsKey(item.toLowerCase())) {
                throw (Command)this.new Command.Fault(i18n, "verb.badOpt", (Object)item);
            }
            this.optionValues.put(item, on);
        }
    }

    @Override
    public void run(CommandContext ctx) {
        for (Map.Entry<String, Boolean> e : this.optionValues.entrySet()) {
            String name = e.getKey();
            boolean value = e.getValue();
            if (name.equalsIgnoreCase(MAX)) {
                ctx.setVerboseMax(value);
                continue;
            }
            if (name.equalsIgnoreCase(QUIET)) {
                ctx.setVerboseQuiet(value);
                continue;
            }
            if (name.equalsIgnoreCase(DATE)) {
                ctx.setVerboseTimestampEnabled(value);
                continue;
            }
            ctx.setVerboseOptionValue(name, value);
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(VerboseCommand.class);
    }
}

