/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.exec.CE_StdPane;
import com.sun.javatest.tool.EditableFileList;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.jthelp.ContextHelpManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class CE_KFLPane
extends CE_StdPane {
    private File[] kflFiles;
    private JToolBar toolBar;
    private ButtonGroup btnGrp;
    private JRadioButton customBtn;
    private JRadioButton noneBtn;
    private CustomPanel customPanel;
    private Listener listener = new Listener();

    CE_KFLPane(UIFactory uif, InterviewParameters config) {
        super(uif, config, "kfl");
        this.updateConfig();
        this.initGUI();
    }

    @Override
    boolean isOKToClose() {
        if (this.kflFiles == null) {
            return true;
        }
        if (this.noneBtn.isSelected()) {
            return true;
        }
        if (this.customBtn.isSelected()) {
            return this.customPanel.isOKToClose();
        }
        throw new Error();
    }

    void updateConfig() {
        if (this.config == null) {
            return;
        }
        this.setEnabled(true);
        this.kflFiles = this.config.getKnownFailureFiles();
    }

    @Override
    void load() {
        this.updateConfig();
        if (this.kflFiles != null && this.kflFiles.length == 0) {
            this.kflFiles = null;
        }
        if (this.kflFiles != null) {
            this.customBtn.setSelected(true);
            this.noneBtn.setSelected(false);
            this.customPanel.load();
        } else {
            this.noneBtn.setSelected(true);
            this.customBtn.setSelected(false);
            this.customPanel.clear();
            this.customPanel.setEnabled(false);
        }
    }

    @Override
    void save() {
        if (this.customBtn.isSelected()) {
            this.customPanel.save();
        } else {
            this.config.setKnownFailureFiles(null);
        }
    }

    private void initGUI() {
        ContextHelpManager.setHelpIDString(this, "confEdit.kflTab.csh");
        JPanel p = this.uif.createPanel("ce.kfl", new BorderLayout(), false);
        this.initToolBar();
        p.add((Component)this.toolBar, "North");
        this.customPanel = new CustomPanel();
        p.add((Component)this.customPanel, "Center");
        this.addBody(p);
        if (this.config == null) {
            this.setEnabled(false);
        }
    }

    private void initToolBar() {
        this.toolBar = new JToolBar(0);
        this.toolBar.setFloatable(false);
        this.btnGrp = new ButtonGroup();
        this.noneBtn = this.uif.createRadioButton("ce.kfl.none", this.btnGrp);
        this.noneBtn.addChangeListener(this.listener);
        this.toolBar.add(this.noneBtn);
        this.customBtn = this.uif.createRadioButton("ce.kfl.custom", this.btnGrp);
        this.customBtn.addChangeListener(this.listener);
        this.toolBar.add(this.customBtn);
    }

    private class CustomPanel
    extends JPanel {
        private EditableFileList filesField;
        private JLabel filesLabel;

        CustomPanel() {
            super(new GridBagLayout());
            this.setName("custom");
            GridBagConstraints c = new GridBagConstraints();
            this.filesLabel = CE_KFLPane.this.uif.createLabel("ce.kfl.custom.files", true);
            c.insets.top = 5;
            c.insets.bottom = 5;
            c.insets.left = 5;
            this.add((Component)this.filesLabel, c);
            FileChooser chooser = new FileChooser(true);
            chooser.addChoosableExtension(".kfl", CE_KFLPane.this.uif.getI18NString("ce.kfl.kflFiles"));
            this.filesField = new EditableFileList(chooser);
            this.filesField.setDuplicatesAllowed(false);
            CE_KFLPane.this.uif.setToolTip(this.filesField, "ce.kfl.custom.files");
            c.fill = 2;
            c.gridwidth = 0;
            c.insets.right = 5;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.filesLabel.setLabelFor(this.filesField);
            this.add((Component)this.filesField, c);
        }

        @Override
        public void setEnabled(boolean b) {
            this.filesField.setEnabled(b);
            this.filesLabel.setEnabled(b);
        }

        void clear() {
            this.filesField.clear();
        }

        boolean isOKToClose() {
            File tsr = CE_KFLPane.this.config.getTestSuite().getRoot();
            File[] files = this.filesField.getFiles();
            if (files.length == 0) {
                CE_KFLPane.this.uif.showError("ce.kfl.custom.noFiles");
                return false;
            }
            for (File file : files) {
                File absFile;
                File file2 = absFile = file.isAbsolute() ? file : new File(tsr, file.getPath());
                if (!absFile.exists()) {
                    CE_KFLPane.this.uif.showError("ce.kfl.custom.cantFindFile", (Object)file);
                    return false;
                }
                if (absFile.isFile() && absFile.canRead()) continue;
                CE_KFLPane.this.uif.showError("ce.kfl.custom.badFile", (Object)file);
                return false;
            }
            return true;
        }

        void load() {
            this.filesField.setFiles(CE_KFLPane.this.kflFiles);
        }

        void save() {
            File[] files = this.filesField.getFiles();
            if (files != null && files.length > 0) {
                CE_KFLPane.this.config.setKnownFailureFiles(files);
            } else {
                CE_KFLPane.this.config.setKnownFailureFiles(null);
            }
        }
    }

    private class Listener
    implements ChangeListener {
        private Listener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (CE_KFLPane.this.noneBtn.isSelected()) {
                CE_KFLPane.this.customPanel.setEnabled(false);
            } else {
                CE_KFLPane.this.customPanel.setEnabled(true);
            }
        }
    }
}

