/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.se.descriptor;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.se.descriptor.B;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final B[] bRef = new B[5];

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] xmlFile = new String[]{"myMappingFile.xml"};
        String[] classes = new String[]{pkgName + "A", pkgName + "B"};
        return this.createDeploymentJar("jpa_se_descriptor.jar", pkgNameWithoutSuffix, classes, "persistence.xml", xmlFile);
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    @Test
    public void test1() throws Exception {
        boolean pass = false;
        try {
            B anotherB = (B)this.getEntityManager().find(B.class, (Object)"1");
            if (anotherB != null) {
                if (anotherB.equals(bRef[0])) {
                    logger.log(System.Logger.Level.TRACE, "get expected B");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected B:" + anotherB.toString());
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test1 failed");
        }
    }

    public void createTestData() {
        logger.log(System.Logger.Level.TRACE, "createTestData");
        try {
            logger.log(System.Logger.Level.TRACE, "Create 2 B Entities");
            Client.bRef[0] = new B("1", "myB", 1);
            Client.bRef[1] = new B("2", "yourB", 2);
            logger.log(System.Logger.Level.TRACE, "Start to persist Bs ");
            for (B b : bRef) {
                if (b == null) continue;
                this.getEntityManager().persist((Object)b);
                logger.log(System.Logger.Level.TRACE, "persisted B " + b);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception while creating test data:" + e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

