/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.jpa22.repeatable.namedstoredprocedurequery;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.jpa22.repeatable.namedstoredprocedurequery.Employee;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.StoredProcedureQuery;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final long serialVersionUID = 22L;
    List<Employee> empRef = new ArrayList<Employee>();
    Employee emp0 = null;
    Properties props = null;
    Map<String, Object> map = new HashMap<String, Object>();
    String dataBaseName = null;
    static final String ORACLE = "oracle";
    static final String POSTGRESQL = "postgresql";

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Employee"};
        return this.createDeploymentJar("jpa_jpa22_repeatable_namedstoredprocedurequery.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupEmployeeData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupOrderData");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createEmployeeData();
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = System.getProperty("jdbc.db");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanupData() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            this.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    @Test
    public void createStoredProcedureQueryStringTest() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpOneFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, String.class, ParameterMode.OUT);
            spq.execute();
            Object oActual = spq.getOutputParameterValue(1);
            if (oActual instanceof String) {
                String actual = (String)oActual;
                if (actual.equals(this.emp0.getFirstName())) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected result: " + this.emp0.getFirstName() + ", actual:" + actual);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected String to be returned, actual:" + oActual.getClass());
            }
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("createStoredProcedureQueryStringTest failed");
        }
    }

    @Test
    public void createStoredProcedureQueryStringClassArrayTest() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            Class[] cArray = new Class[]{Employee.class};
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", cArray);
            if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                logger.log(System.Logger.Level.TRACE, "register refcursor parameter");
                spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            if (spq.execute()) {
                List<List<Employee>> listOfList = this.getResultSetsFromStoredProcedure(spq);
                if (listOfList.size() == 1) {
                    ArrayList<Integer> expected = new ArrayList<Integer>();
                    for (Employee e : this.empRef) {
                        expected.add(e.getId());
                    }
                    pass = this.verifyListOfListEmployeeIds(expected, listOfList);
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected execute() to return true, actual: false");
            }
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("createStoredProcedureQueryStringClassArrayTest failed");
        }
    }

    @Test
    public void createStoredProcedureQueryStringStringArrayTest() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        this.clearCache();
        try {
            String[] sArray = new String[]{"id-firstname-lastname"};
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", sArray);
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                logger.log(System.Logger.Level.TRACE, "register refcursor parameter");
                spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            spq.setParameter(1, (Object)1);
            if (spq.execute()) {
                List<List<Employee>> listOfList = this.getResultSetsFromStoredProcedure(spq);
                if (listOfList.size() == 1) {
                    ArrayList<Employee> expected = new ArrayList<Employee>();
                    expected.add(new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName()));
                    pass = this.verifyListOfListEmployees(expected, listOfList);
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected execute() to return true, actual: false");
            }
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("createStoredProcedureQueryStringStringArrayTest failed");
        }
    }

    @Test
    public void createNamedStoredProcedureQueryStringTest() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        this.clearCache();
        try {
            StoredProcedureQuery spq = null;
            if (this.dataBaseName.equalsIgnoreCase(ORACLE) || this.dataBaseName.equalsIgnoreCase(POSTGRESQL)) {
                logger.log(System.Logger.Level.TRACE, "Calling refcursor specific named stored procedure query");
                spq = this.getEntityManager().createNamedStoredProcedureQuery("get-id-firstname-lastname-refcursor");
            } else {
                spq = this.getEntityManager().createNamedStoredProcedureQuery("get-id-firstname-lastname");
            }
            spq.setParameter(1, (Object)1);
            if (spq.execute()) {
                List<List<Employee>> listOfList = this.getResultSetsFromStoredProcedure(spq);
                if (listOfList.size() == 1) {
                    ArrayList<Employee> expected = new ArrayList<Employee>();
                    expected.add(new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName()));
                    pass = this.verifyListOfListEmployees(expected, listOfList);
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected execute() to return true, actual: false");
            }
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception:", (Throwable)ex);
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("createNamedStoredProcedureQueryStringTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeData() {
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Creating Employees");
            Date d1 = this.getUtilDate("2000-02-14");
            Date d2 = this.getUtilDate("2001-06-27");
            Date d3 = this.getUtilDate("2002-07-07");
            Date d4 = this.getUtilDate("2003-03-03");
            Date d5 = this.getUtilDate();
            this.emp0 = new Employee(1, "Alan", "Frechette", d1, 35000.0f);
            this.empRef.add(this.emp0);
            this.empRef.add(new Employee(2, "Arthur", "Frechette", d2, 35000.0f));
            this.empRef.add(new Employee(3, "Shelly", "McGowan", d3, 50000.0f));
            this.empRef.add(new Employee(4, "Robert", "Bissett", d4, 55000.0f));
            this.empRef.add(new Employee(5, "Stephen", "DMilla", d5, 25000.0f));
            for (Employee e : this.empRef) {
                if (e == null) continue;
                this.getEntityManager().persist((Object)e);
                logger.log(System.Logger.Level.TRACE, "persisted employee:" + e);
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }

    private List<List<Employee>> getResultSetsFromStoredProcedure(StoredProcedureQuery spq) {
        logger.log(System.Logger.Level.TRACE, "in getResultSetsFromStoredProcedure");
        boolean results = true;
        ArrayList<List<Employee>> listOfList = new ArrayList<List<Employee>>();
        int rsnum = 1;
        int rowsAffected = 0;
        do {
            if (results) {
                logger.log(System.Logger.Level.TRACE, "Processing set:" + rsnum);
                ArrayList<Employee> empList = new ArrayList<Employee>();
                List list = spq.getResultList();
                if (list != null) {
                    logger.log(System.Logger.Level.TRACE, "Getting result set: " + rsnum + ", size:" + list.size());
                    for (Object o : list) {
                        if (o instanceof Employee) {
                            Employee e = (Employee)o;
                            logger.log(System.Logger.Level.TRACE, "Saving:" + e);
                            empList.add(e);
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "Did not get instance of Employee, instead got:" + o.getClass().getName());
                    }
                    if (empList.size() > 0) {
                        listOfList.add(empList);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Result set[" + rsnum + "] returned was null");
                }
                ++rsnum;
            } else {
                rowsAffected = spq.getUpdateCount();
                if (rowsAffected >= 0) {
                    logger.log(System.Logger.Level.TRACE, "rowsAffected:" + rowsAffected);
                }
            }
            results = spq.hasMoreResults();
            logger.log(System.Logger.Level.TRACE, "Results:" + results);
        } while (results || rowsAffected != -1);
        return listOfList;
    }

    private boolean verifyListOfListEmployeeIds(List<Integer> expected, List<List<Employee>> listOfList) {
        boolean result = false;
        int count = 0;
        for (List<Employee> lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee employee : lEmp) {
                    actual.add(employee.getId());
                }
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:");
                    for (Integer n : actual) {
                        logger.log(System.Logger.Level.TRACE, "id:" + n);
                    }
                    ++count;
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, "Did not receive expected result:");
                for (Integer n : expected) {
                    logger.log(System.Logger.Level.ERROR, " Expected id:" + n);
                }
                for (Integer n : actual) {
                    logger.log(System.Logger.Level.ERROR, "Actual id:" + n);
                }
                continue;
            }
            logger.log(System.Logger.Level.ERROR, "Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    private boolean verifyListOfListEmployees(List<Employee> expected, List<List<Employee>> listOfList) {
        boolean result = false;
        int count = 0;
        for (List<Employee> lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Employee> actual = new ArrayList<Employee>();
                for (Employee e : lEmp) {
                    actual.add(e);
                }
                if (!this.verifyListEmployees(expected, actual)) continue;
                ++count;
                continue;
            }
            logger.log(System.Logger.Level.ERROR, "Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    private boolean verifyListEmployees(List<Employee> expected, List<Employee> actual) {
        boolean result = false;
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            for (Employee e : expected) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:" + e);
            }
            result = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Did not receive expected result:");
            for (Employee e : expected) {
                logger.log(System.Logger.Level.ERROR, "expected employee:" + e);
            }
            for (Employee e : actual) {
                logger.log(System.Logger.Level.ERROR, "actual employee :" + e);
            }
        }
        return result;
    }
}

