/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.jpa22.generators.tablegenerators;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.jpa22.generators.tablegenerators.DataTypes;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final long serialVersionUID = 22L;
    private DataTypes d0;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DataTypes"};
        return this.createDeploymentJar("jpa_jpa22_generators_tablegenerators.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void generatorOnEntityTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            int id = this.d0.getId();
            logger.log(System.Logger.Level.TRACE, "find id: " + id);
            DataTypes d = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)id);
            if (d != null) {
                if (d.getStringData().equals(this.d0.getStringData())) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("generatorOnEntityTest failed");
        }
    }

    public void createTestData() {
        try {
            this.getEntityTransaction().begin();
            this.d0 = new DataTypes();
            this.d0.setStringData("testData");
            logger.log(System.Logger.Level.TRACE, "DataType:" + this.d0.toString());
            this.getEntityManager().persist((Object)this.d0);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

