/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.types.primarykey.compound;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.types.primarykey.compound.CompoundPK;
import ee.jakarta.tck.persistence.core.types.primarykey.compound.CompoundPK2;
import ee.jakarta.tck.persistence.core.types.primarykey.compound.CompoundPK3;
import ee.jakarta.tck.persistence.core.types.primarykey.compound.TestBean;
import ee.jakarta.tck.persistence.core.types.primarykey.compound.TestBean2;
import ee.jakarta.tck.persistence.core.types.primarykey.compound.TestBean3;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final CompoundPK refPK1 = new CompoundPK(1, "cof0001", 1.0f);
    private static final CompoundPK refPK2 = new CompoundPK(2, "cof0002", 2.0f);
    private static final CompoundPK2 refPK3 = new CompoundPK2(3, "cof0003", 3.0f);
    private static final CompoundPK2 refPK4 = new CompoundPK2(4, "cof0004", 4.0f);
    private static final CompoundPK3 refPK5 = new CompoundPK3(5, "cof0005", 5.0f);
    private static final CompoundPK3 refPK6 = new CompoundPK3(6, "cof0006", 6.0f);

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "CompoundPK", pkgName + "CompoundPK2", pkgName + "CompoundPK3", pkgName + "TestBean", pkgName + "TestBean2", pkgName + "TestBean3"};
        return this.createDeploymentJar("jpa_core_types_primarykey_compound.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Entering setup");
        super.setup();
        this.createDeployment();
        this.removeTestData();
    }

    @Test
    public void testCompoundPK1() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Creating bean1 and bean2 instance...");
            TestBean bean1 = new TestBean(refPK1, "Arabica", 10.0f);
            TestBean bean2 = new TestBean(refPK2, "Java", 12.0f);
            this.getEntityManager().persist((Object)bean1);
            this.getEntityManager().persist((Object)bean2);
            this.getEntityManager().flush();
            logger.log(System.Logger.Level.TRACE, "[Client] Locate beans using primary keys...");
            TestBean bean3 = (TestBean)this.getEntityManager().find(TestBean.class, (Object)refPK1);
            TestBean bean4 = (TestBean)this.getEntityManager().find(TestBean.class, (Object)refPK2);
            logger.log(System.Logger.Level.TRACE, "Check we can call the beans...");
            bean1.ping();
            bean2.ping();
            bean3.ping();
            bean4.ping();
            logger.log(System.Logger.Level.TRACE, "Check beans are identical...");
            if (bean1 == bean3) {
                logger.log(System.Logger.Level.TRACE, "bean1 and bean3 are equal");
                pass = true;
            }
            if (!pass) {
                throw new Exception("testCompoundPK1: bean1 and bean3 should be identical!");
            }
            if (bean2 == bean4) {
                logger.log(System.Logger.Level.TRACE, "bean2 and bean4 are equal");
                pass = true;
            }
            if (!pass) {
                throw new Exception("[testCompoundPK1] bean2 and bean4 should be identical!");
            }
            logger.log(System.Logger.Level.TRACE, "Comparing primary keys...");
            CompoundPK valPK1 = bean3.getCompoundPK();
            CompoundPK valPK2 = bean4.getCompoundPK();
            if (valPK1.equals(refPK1) && refPK1.equals(valPK1)) {
                logger.log(System.Logger.Level.TRACE, "testCompoundPK1: valPK1 equals refPK1");
                pass = true;
            }
            if (!pass) {
                throw new Exception("testCompoundPK1: bean1 and bean3 PK should match!");
            }
            if (valPK2.equals(refPK2) && refPK2.equals(valPK2)) {
                logger.log(System.Logger.Level.TRACE, "testCompoundPK1: valPK2 equals refPK2");
                pass = true;
            }
            if (!pass) {
                throw new Exception("[testCompoundPK1] bean2 and bean4 PK should match!");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "[testCompoundPK1] Caught exception: " + e);
            throw new Exception("testCompoundPK1 test failed: " + e, e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[testCompoundPK1] Exception caught while rolling back TX", (Throwable)e);
            }
        }
    }

    @Test
    public void testCompoundPK2() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Creating bean1 and bean2 instance...");
            TestBean2 bean1 = new TestBean2(3, "cof0003", Float.valueOf(3.0f), "Vanilla", 10.0f);
            TestBean2 bean2 = new TestBean2(4, "cof0004", Float.valueOf(4.0f), "Mocha Java", 12.0f);
            this.getEntityManager().persist((Object)bean1);
            this.getEntityManager().persist((Object)bean2);
            this.getEntityManager().flush();
            logger.log(System.Logger.Level.TRACE, "Locate beans using primary keys...");
            TestBean2 bean3 = (TestBean2)this.getEntityManager().find(TestBean2.class, (Object)refPK3);
            TestBean2 bean4 = (TestBean2)this.getEntityManager().find(TestBean2.class, (Object)refPK4);
            logger.log(System.Logger.Level.TRACE, "Check we can call the beans...");
            bean1.ping();
            bean2.ping();
            bean3.ping();
            bean4.ping();
            logger.log(System.Logger.Level.TRACE, "Check beans are identical...");
            if (bean1 == bean3) {
                logger.log(System.Logger.Level.TRACE, "bean1 and bean3 are equal");
                pass = true;
            }
            if (!pass) {
                throw new Exception("[testCompoundPK2] bean1 and bean3 should be identical!");
            }
            if (bean2 == bean4) {
                logger.log(System.Logger.Level.TRACE, "bean2 and bean4 are equal");
                pass = true;
            }
            if (!pass) {
                throw new Exception("[testCompoundPK2] bean2 and bean4 PK should match!");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "[testCompoundPK2] Caught exception: " + e);
            throw new Exception("testCompoundPK2 test failed: " + e, e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[testCompoundPK2] Exception caught while rolling back TX", (Throwable)e);
            }
        }
    }

    @Test
    public void testCompoundPK3() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Creating bean1 and bean2 instance...");
            TestBean3 bean1 = new TestBean3(5, "cof0005", Float.valueOf(5.0f), "Cinnamon", 11.0f);
            TestBean3 bean2 = new TestBean3(6, "cof0006", Float.valueOf(6.0f), "Hazelnut", 12.0f);
            this.getEntityManager().persist((Object)bean1);
            this.getEntityManager().persist((Object)bean2);
            this.getEntityManager().flush();
            logger.log(System.Logger.Level.TRACE, "Locate beans using primary keys...");
            TestBean3 bean3 = (TestBean3)this.getEntityManager().find(TestBean3.class, (Object)refPK5);
            TestBean3 bean4 = (TestBean3)this.getEntityManager().find(TestBean3.class, (Object)refPK6);
            logger.log(System.Logger.Level.TRACE, "Check we can call the beans...");
            bean1.ping();
            bean2.ping();
            bean3.ping();
            bean4.ping();
            logger.log(System.Logger.Level.TRACE, "Check beans are identical...");
            if (bean1 == bean3) {
                logger.log(System.Logger.Level.TRACE, "bean1 and bean3 are equal");
                pass = true;
            }
            if (!pass) {
                throw new Exception("[testCompoundPK3] bean1 and bean3 should be identical!");
            }
            if (bean2 == bean4) {
                logger.log(System.Logger.Level.TRACE, "bean2 and bean4 are equal");
                pass = true;
            }
            if (!pass) {
                throw new Exception("[testCompoundPK3] bean2 and bean4 PK should match!");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "[testCompoundPK3] Caught exception: " + e);
            throw new Exception("testCompoundPK3 test failed: " + e, e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "[testCompoundPK3] Exception caught while rolling back TX", (Throwable)e);
            }
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PKEY").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

