/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.unimanyxone;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.relationship.unimanyxone.UniMX1Person;
import ee.jakarta.tck.persistence.core.relationship.unimanyxone.UniMX1Project;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "UniMX1Person", pkgName + "UniMX1Project"};
        return this.createDeploymentJar("jpa_core_relationship_unimanyxone.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void uniMX1Test1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin uniMX1Test1");
        boolean pass = false;
        try {
            UniMX1Project newProject2;
            UniMX1Person newPerson2;
            UniMX1Project newProject;
            this.getEntityTransaction().begin();
            UniMX1Project project1 = new UniMX1Project(1L, "JavaEE", Float.valueOf(500.0f));
            UniMX1Person person1 = new UniMX1Person(1L, "Duke");
            UniMX1Person person2 = new UniMX1Person(2L, "Foo");
            this.getEntityManager().persist((Object)project1);
            this.getEntityManager().persist((Object)person1);
            this.getEntityManager().persist((Object)person2);
            person1.setProject(project1);
            person2.setProject(project1);
            this.getEntityManager().merge((Object)person1);
            this.getEntityManager().merge((Object)person2);
            logger.log(System.Logger.Level.TRACE, "persisted Persons and Project");
            boolean pass1 = false;
            boolean pass2 = false;
            UniMX1Person newPerson = (UniMX1Person)this.getEntityManager().find(UniMX1Person.class, (Object)1L);
            if (newPerson != null && (newProject = newPerson.getProject()).getName().equals("JavaEE")) {
                pass1 = true;
            }
            if ((newPerson2 = (UniMX1Person)this.getEntityManager().find(UniMX1Person.class, (Object)2L)) != null && (newProject2 = newPerson2.getProject()).getName().equals("JavaEE")) {
                pass2 = true;
            }
            if (pass1 && pass2) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Unexpected results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("uniMX1Test1 failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM UNIMX1PERSON").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM UNIMX1PROJECT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

