/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.metamodelquery;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.schema30.Address_;
import ee.jakarta.tck.persistence.common.schema30.Country_;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Customer_;
import ee.jakarta.tck.persistence.common.schema30.Spouse;
import ee.jakarta.tck.persistence.common.schema30.Spouse_;
import ee.jakarta.tck.persistence.common.schema30.UtilCustomerData;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.FetchParent;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.PluralAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client1
extends UtilCustomerData {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_metamodelquery1.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest2() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Execute findAllCustomers");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root c = cquery.from(Customer.class);
            cquery.select((Selection)c);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[this.customerRef.length];
            for (int i = 0; i < this.customerRef.length; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected " + this.customerRef.length + " references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest2 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest4() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            Customer expected = (Customer)this.getEntityManager().find(Customer.class, (Object)"3");
            logger.log(System.Logger.Level.TRACE, "find Customer with Home Address in Swansea");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where(new Predicate[]{cbuilder.equal((Expression)customer.get(Customer_.home).get(Address_.street), (Expression)cbuilder.parameter(String.class, "street")), cbuilder.equal((Expression)customer.get(Customer_.home).get(Address_.city), (Expression)cbuilder.parameter(String.class, "city")), cbuilder.equal((Expression)customer.get(Customer_.home).get(Address_.state), (Expression)cbuilder.parameter(String.class, "state")), cbuilder.equal((Expression)customer.get(Customer_.home).get(Address_.zip), (Expression)cbuilder.parameter(String.class, "zip"))}).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("street", (Object)"125 Moxy Lane").setParameter("city", (Object)"Swansea").setParameter("state", (Object)"MA").setParameter("zip", (Object)"11345");
            Customer c = (Customer)tquery.getSingleResult();
            if (expected == c) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest4 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest6() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find Customers with Home Address Information");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.or(new Predicate[]{cbuilder.equal((Expression)customer.get(Customer_.home).get(Address_.street), (Expression)cbuilder.parameter(String.class, "street")), cbuilder.equal((Expression)customer.get(Customer_.home).get(Address_.city), (Expression)cbuilder.parameter(String.class, "city")), cbuilder.equal((Expression)customer.get(Customer_.home).get(Address_.state), (Expression)cbuilder.parameter(String.class, "state")), cbuilder.equal((Expression)customer.get(Customer_.home).get(Address_.zip), (Expression)cbuilder.parameter(String.class, "zip"))}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("street", (Object)"47 Skyline Drive");
            tquery.setParameter("city", (Object)"Chelmsford");
            tquery.setParameter("state", (Object)"VT");
            tquery.setParameter("zip", (Object)"02155");
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "10", "11", "13"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 4 references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest6 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest15() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            Customer expected = (Customer)this.getEntityManager().find(Customer.class, (Object)"5");
            logger.log(System.Logger.Level.TRACE, "find customer with name: Stephen S. D'Milla");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_.name), (Expression)cbuilder.parameter(String.class, "cName")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("cName", (Object)"Stephen S. D'Milla");
            Customer c = (Customer)tquery.getSingleResult();
            if (expected == c) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest15 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest16() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all customers IN home city: Lexington");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)customer.get(Customer_.home).get(Address_.city).in(new Object[]{"Lexington"}));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest16 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest17() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all customers NOT IN home city: Swansea or Brookline");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join h = customer.join(Customer_.home, JoinType.LEFT);
            cquery.where((Expression)h.get(Address_.city).in(new Object[]{"Swansea", "Brookline"}).not());
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "5", "6", "7", "8", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 15 references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest17 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest18() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find All Customers with home ZIP CODE that ends in 77");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.like((Expression)customer.get(Customer_.home).get(Address_.zip), "%77"));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest18 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest19() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all customers with a home zip code that does not contain 44 in the third and fourth position");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.notLike((Expression)customer.get(Customer_.home).get(Address_.zip), "%44_"));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 15 references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest19 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest22() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find All Customers who have a null work zip code");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)customer.get(Customer_.work).get(Address_.zip).isNull());
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"13"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest22 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest23() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all customers who do not have null work zip code entry");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)customer.get(Customer_.work).get(Address_.zip).isNotNull());
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 17 references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest23 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest36() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all customers who lives in city Attleboro");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)customer.get(Customer_.home).get(Address_.city).in(new Expression[]{cbuilder.parameter(String.class, "city")}));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("city", (Object)"Attleboro");
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"13"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest36 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest37() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Execute two queries composed differently and verify results");
            CriteriaQuery cquery1 = cbuilder.createQuery(Customer.class);
            Root customer1 = cquery1.from(Customer.class);
            cquery1.where((Expression)customer1.get(Customer_.home).get(Address_.state).in(new Object[]{"NH", "RI"})).select((Selection)customer1);
            TypedQuery tquery1 = this.getEntityManager().createQuery(cquery1);
            tquery1.setMaxResults(this.customerRef.length);
            List clist1 = tquery1.getResultList();
            String[] expectedPKs = new String[]{"5", "6", "12", "14", "16"};
            CriteriaQuery cquery2 = cbuilder.createQuery(Customer.class);
            Root customer2 = cquery2.from(Customer.class);
            cquery2.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)customer2.get(Customer_.home).get(Address_.state), (Object)"NH"), (Expression)cbuilder.equal((Expression)customer2.get(Customer_.home).get(Address_.state), (Object)"RI"))).select((Selection)customer2);
            TypedQuery tquery2 = this.getEntityManager().createQuery(cquery2);
            tquery2.setMaxResults(this.customerRef.length);
            List clist2 = tquery2.getResultList();
            String[] expectedPKs2 = new String[]{"5", "6", "12", "14", "16"};
            if (!this.checkEntityPK(clist1, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results for first query.  Expected 5 reference, got: " + clist1.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received for first query");
                pass1 = true;
            }
            if (!this.checkEntityPK(clist2, expectedPKs2)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results for second query.  Expected 5 reference, got: " + clist2.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received for second query");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest37 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest47() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Object[] expectedZips = new String[]{"00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "11345"};
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find work zip codes that are not null");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isNotNull((Expression)customer.get(Customer_.work).get(Address_.zip))).select((Selection)customer.get(Customer_.work).get(Address_.zip)).orderBy(new Order[]{cbuilder.asc((Expression)customer.get(Customer_.work).get(Address_.zip))});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            Object[] result = clist.toArray(new String[clist.size()]);
            logger.log(System.Logger.Level.TRACE, "Compare results of work zip codes");
            pass = Arrays.equals(expectedZips, result);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest47 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest52() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.isNotNull((Expression)customer.get(Customer_.country)), (Expression)cbuilder.equal((Expression)customer.get(Customer_.name), (Expression)cbuilder.parameter(String.class, "cName"))));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("cName", (Object)"Shelly D. McGowan");
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest52 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest56() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        String[] expectedZips = new String[]{"00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "11345"};
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all work zip codes");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer.get(Customer_.work).get(Address_.zip));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            if (clist.size() != 18) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 18 references, got: " + clist.size());
            } else {
                pass1 = true;
                int numOfNull = 0;
                int foundZip = 0;
                block2: for (String s : clist) {
                    logger.log(System.Logger.Level.TRACE, "Check contents of List for null");
                    String o = s;
                    if (o == null) {
                        ++numOfNull;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Check List for expected zip codes");
                    for (int l = 0; l < 17; ++l) {
                        if (!expectedZips[l].equals(o)) continue;
                        ++foundZip;
                        continue block2;
                    }
                }
                if (numOfNull != 1 || foundZip != 17) {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results");
                    pass2 = false;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Expected results received");
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest56 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest58() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find home zip codes");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_.home).get(Address_.street), (Object)"212 Edgewood Drive")).select((Selection)customer.get(Customer_.name));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Object s = tquery.getSingleResult();
            if (s != null) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected null.");
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest58 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest59() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "determine which customers have an null name");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isNull((Expression)customer.get(Customer_.name)));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest59 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest61() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join w = customer.join(Customer_.work, JoinType.LEFT);
            cquery.where((Expression)cbuilder.isNull((Expression)w.get(Address_.zip)));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"13", "19", "20"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 3 references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest61 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest64() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_.work).get(Address_.city), (Expression)cbuilder.parameter(String.class, "workcity")));
            cquery.select((Selection)cbuilder.construct(Customer.class, new Selection[]{customer.get(Customer_.id), customer.get(Customer_.name)}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("workcity", (Object)"Burlington");
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 18 references, got: " + clist.size());
                pass = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest64 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest69() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        Long expectedResult1 = 17L;
        Long expectedResult2 = 16L;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            CriteriaQuery cquery1 = cbuilder.createQuery(Long.class);
            Root customer1 = cquery1.from(Customer.class);
            cquery1.select((Selection)cbuilder.count((Expression)customer1.get(Customer_.home).get(Address_.city)));
            TypedQuery tquery1 = this.getEntityManager().createQuery(cquery1);
            Long result1 = (Long)tquery1.getSingleResult();
            if (!result1.equals(expectedResult1)) {
                logger.log(System.Logger.Level.ERROR, "Query1 in queryTest69 returned:" + result1 + " expected: " + expectedResult1);
            } else {
                logger.log(System.Logger.Level.TRACE, "query1 in queryTest69 returned expected results");
                pass1 = true;
            }
            CriteriaQuery cquery2 = cbuilder.createQuery(Long.class);
            Root customer2 = cquery2.from(Customer.class);
            cquery2.select((Selection)cbuilder.countDistinct((Expression)customer2.get(Customer_.home).get(Address_.city)));
            TypedQuery tquery2 = this.getEntityManager().createQuery(cquery2);
            Long result2 = (Long)tquery2.getSingleResult();
            if (!result2.equals(expectedResult2)) {
                logger.log(System.Logger.Level.ERROR, "Query 2 in queryTest69 returned:" + result2 + " expected: " + expectedResult2);
            } else {
                logger.log(System.Logger.Level.TRACE, "query 2 in queryTest69 returned expected results");
                pass2 = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest69 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void queryTest71() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Check if a spouse is related to a customer");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root spouse = cquery.from(Spouse.class);
            cquery.where((Expression)cbuilder.equal((Expression)spouse.get(Spouse_.id), (Object)"7")).select((Selection)spouse.get(Spouse_.customer));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.getSingleResult();
            this.getEntityTransaction().commit();
        }
        catch (NoResultException e) {
            logger.log(System.Logger.Level.TRACE, "queryTest71: NoResultException caught as expected : " + e);
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest71 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void test_leftouterjoin_1xM() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.join(Customer_.creditCards, JoinType.LEFT);
            cquery.where((Expression)cbuilder.like((Expression)customer.get(Customer_.name), "%Caruso")).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 2 references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_leftouterjoin_1xM failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void test_groupBy() throws Exception {
        boolean pass = false;
        Object[] expectedCodes = new String[]{"CHA", "GBR", "IRE", "JPN", "USA"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer.get(Customer_.country).get(Country_.code));
            cquery.groupBy(new Expression[]{customer.get(Customer_.country).get(Country_.code)});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.country.length);
            List result = tquery.getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expectedCodes, output);
            if (!pass) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 4 Country Codes: CHA, GBR, JPN, USA. Received: " + result.size());
                for (String s : result) {
                    logger.log(System.Logger.Level.TRACE, " Credit Card Type: " + s);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_groupBy failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void test_innerjoin_1x1() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.join(Customer_.spouse);
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expectedPKs.length + " references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_innerjoin_1x1 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void fetchFetchSingularAttributeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Fetch f = customer.fetch(Customer_.spouse);
            Fetch f1 = f.fetch(Customer_.spouse);
            Attribute attr = f1.getAttribute();
            if (attr.getName().equals(Customer_.spouse.getName())) {
                logger.log(System.Logger.Level.TRACE, "Received expected attribute:" + attr.getName());
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected attribute:" + Customer_.spouse.getName() + ", actual:" + attr.getName());
            }
            JoinType jt = f1.getJoinType();
            if (jt.equals((Object)JoinType.INNER)) {
                logger.log(System.Logger.Level.TRACE, "Received expected JoinType:" + jt.name());
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected JoinType:" + JoinType.INNER.name() + ", actual:" + jt.name());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("fetchFetchSingularAttributeTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void fetchFetchSingularAttributeJoinTypeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Fetch f = customer.fetch(Customer_.spouse);
            Fetch f1 = f.fetch(Customer_.spouse, JoinType.INNER);
            Attribute attr = f1.getAttribute();
            if (attr.getName().equals(Customer_.spouse.getName())) {
                logger.log(System.Logger.Level.TRACE, "Received expected attribute:" + attr.getName());
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected attribute:" + Customer_.spouse.getName() + ", actual:" + attr.getName());
            }
            JoinType jt = f1.getJoinType();
            if (jt.equals((Object)JoinType.INNER)) {
                logger.log(System.Logger.Level.TRACE, "Received expected JoinType:" + jt.name());
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected JoinType:" + JoinType.INNER.name() + ", actual:" + jt.name());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("fetchFetchSingularAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void fetchTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root c1 = cquery.from(Customer.class);
            JoinType jt = c1.fetch(Customer_.spouse).getJoinType();
            if (jt.equals((Object)JoinType.INNER)) {
                logger.log(System.Logger.Level.TRACE, "Received expected JoinType:" + jt.name());
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected JoinType:" + JoinType.INNER.name() + ", actual:" + jt.name());
            }
            Root c2 = cquery.from(Customer.class);
            jt = c2.fetch(Customer_.spouse, JoinType.INNER).getJoinType();
            if (jt.equals((Object)JoinType.INNER)) {
                logger.log(System.Logger.Level.TRACE, "Received expected JoinType:" + jt.name());
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected JoinType:" + JoinType.INNER.name() + ", actual:" + jt.name());
            }
            Root c3 = cquery.from(Customer.class);
            jt = c3.fetch(Customer_.spouse, JoinType.LEFT).getJoinType();
            if (jt.equals((Object)JoinType.LEFT)) {
                logger.log(System.Logger.Level.TRACE, "Received expected JoinType:" + jt.name());
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected JoinType:" + JoinType.LEFT.name() + ", actual:" + jt.name());
            }
            Root c4 = cquery.from(Customer.class);
            Attribute attr = c4.fetch(Customer_.spouse).getAttribute();
            if (attr.getName().equals(Customer_.spouse.getName())) {
                logger.log(System.Logger.Level.TRACE, "Received expected attribute:" + attr.getName());
                pass4 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected attribute:" + Customer_.spouse.getName() + ", actual:" + attr.getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("fetchTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void fetchGetParentTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            FetchParent fp = customer.fetch(Customer_.spouse).getParent();
            Set f = fp.getFetches();
            if (f.size() == 1) {
                for (Fetch tmpFetch : f) {
                    String name = tmpFetch.getAttribute().getName();
                    if (name.equals("spouse")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected Fetch:" + name + ", which means the correct FetchParent was returned");
                        pass = true;
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "Expected: spouse, actual:" + name);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected 1 fetch to be returned from FetchParent.getFetches(), got:" + f.size());
                for (Fetch tmpFetch : f) {
                    String name = tmpFetch.getAttribute().getName();
                    logger.log(System.Logger.Level.ERROR, "Fetch returned was:" + name);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("fetchGetParentTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void test_fetchjoin_1x1() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Set cFetches = customer.getFetches();
            if (cFetches.size() != 0) {
                logger.log(System.Logger.Level.ERROR, "Did not get correct number of fetches, expected:0, actual:" + cFetches.size());
                for (Object o : cFetches) {
                    logger.log(System.Logger.Level.ERROR, "Fetch:" + o.toString());
                }
            }
            customer.fetch(Customer_.spouse);
            cFetches = customer.getFetches();
            if (cFetches.size() == 1) {
                logger.log(System.Logger.Level.TRACE, "Received expected number of fetches" + cFetches.size());
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get correct number of fetches, expected:1, actual:" + cFetches.size());
                for (Object o : cFetches) {
                    logger.log(System.Logger.Level.ERROR, "Fetch:" + o.toString());
                }
            }
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expectedPKs.length + " references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_fetchjoin_1x1 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void fetchSingularAttributeJoinType1X1Test() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.fetch(Customer_.spouse, JoinType.INNER);
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expectedPKs.length + " references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("fetchSingularAttributeJoinType1X1Test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void test_fetchjoin_1xM() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.fetch((PluralAttribute)Customer_.orders, JoinType.LEFT);
            cquery.where((Expression)customer.get(Customer_.home).get(Address_.state).in(new Object[]{"NY", "RI"}));
            cquery.select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"14", "17"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expectedPKs.length + " references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "test_fetchjoin_1xM failed", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_fetchjoin_1xM failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void test_groupByHaving() throws Exception {
        boolean pass = false;
        Long expectedGBR = 2L;
        Long expectedCHA = 4L;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            cquery.groupBy(new Expression[]{customer.get(Customer_.country).get(Country_.code)}).having((Expression)customer.get(Customer_.country).get(Country_.code).in(new Object[]{"GBR", "CHA"})).select((Selection)cbuilder.count((Expression)customer));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.country.length);
            List result = tquery.getResultList();
            int numOfExpected = 0;
            for (Long l : result) {
                logger.log(System.Logger.Level.TRACE, "Check result received . . . ");
                if (!l.equals(expectedGBR) && !l.equals(expectedCHA)) continue;
                ++numOfExpected;
            }
            if (numOfExpected != 2) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 2 Values returned : 2 with Country Code GBR and 4 with Country Code CHA. Received: " + result.size());
                for (Long l : result) {
                    logger.log(System.Logger.Level.TRACE, "count of Codes Returned: " + l);
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received.");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_groupByHaving failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void test_concatHavingClause() throws Exception {
        boolean pass = false;
        String expectedCustomer = "Margaret Mills";
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer.get(Customer_.name)).groupBy(new Expression[]{customer.get(Customer_.name)}).having((Expression)cbuilder.equal((Expression)customer.get(Customer_.name), cbuilder.concat("Margaret ", (Expression)cbuilder.parameter(String.class, "lname"))));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("lname", (Object)"Mills");
            String result = (String)tquery.getSingleResult();
            if (result.equals("Margaret Mills")) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.TRACE, "test_concatHavingClause:  Did not get expected results. Expected: Margaret Mills, got: " + result);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_concatHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void test_lowerHavingClause() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        Long expectedCount = 2L;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)cbuilder.count((Expression)customer.get(Customer_.country).get(Country_.code))).groupBy(new Expression[]{customer.get(Customer_.country).get(Country_.code)}).having((Expression)cbuilder.equal(cbuilder.lower((Expression)customer.get(Customer_.country).get(Country_.code)), (Object)"gbr"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (result.size() == 1) {
                pass1 = true;
                Long l = (Long)result.get(0);
                if (l.equals(expectedCount)) {
                    logger.log(System.Logger.Level.TRACE, "Expected results received");
                    pass2 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected result:" + expectedCount + ", actual:" + l);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected 1, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception(" test_lowerHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void test_upperHavingClause() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        Long expectedCount = 2L;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)cbuilder.count((Expression)customer.get(Customer_.country).get(Country_.country))).groupBy(new Expression[]{customer.get(Customer_.country).get(Country_.country)}).having((Expression)cbuilder.equal(cbuilder.upper((Expression)customer.get(Customer_.country).get(Country_.country)), (Object)"ENGLAND"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (result.size() == 1) {
                pass1 = true;
                Long l = (Long)result.get(0);
                if (l.equals(expectedCount)) {
                    logger.log(System.Logger.Level.TRACE, "Expected results received");
                    pass2 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected result:" + expectedCount + ", actual:" + l);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected 1, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("test_upperHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void test_lengthHavingClause() throws Exception {
        boolean pass = false;
        Object[] expectedCities = new String[]{"Burlington", "Chelmsford", "Roslindale"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join(Customer_.home);
            cquery.groupBy(new Expression[]{a.get(Address_.city)}).having((Expression)cbuilder.equal(cbuilder.length((Expression)a.get(Address_.city)), (Object)10)).select((Selection)a.get(Address_.city));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expectedCities, output);
            if (!pass) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 2 Cities, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_lengthHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void test_locateHavingClause() throws Exception {
        boolean pass = false;
        Object[] expectedCusts = new String[]{"Alan E. Frechette", "Arthur D. Frechette"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.groupBy(new Expression[]{customer.get(Customer_.name)}).having((Expression)cbuilder.gt(cbuilder.locate((Expression)customer.get(Customer_.name), "Frechette"), (Number)0)).select((Selection)customer.get(Customer_.name));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expectedCusts, output);
            if (!pass) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 2 Customers, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception(" test_locateHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void test_subquery_in() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.correlate(customer);
            Join w = sqc.join(Customer_.work);
            sq.select((Expression)w.get(Address_.state));
            sq.where((Expression)cbuilder.equal((Expression)w.get(Address_.state), (Expression)cbuilder.parameter(String.class, "state")));
            cquery.where((Expression)customer.get(Customer_.home).get(Address_.state).in(new Expression[]{sq}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("state", (Object)"MA");
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "7", "8", "9", "11", "13", "15", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_in:  Did not get expected results.  Expected 11 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_subquery_in failed");
        }
    }
}

