/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.version;

import ee.jakarta.tck.persistence.core.annotations.version.Client;
import ee.jakarta.tck.persistence.core.annotations.version.LongClass_Field;
import ee.jakarta.tck.persistence.core.annotations.version.LongClass_Property;
import ee.jakarta.tck.persistence.core.annotations.version.Long_Field;
import ee.jakarta.tck.persistence.core.annotations.version.Long_Property;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client3
extends Client {
    private static final System.Logger logger = System.getLogger(Client3.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = Client.class.getPackageName() + ".";
        String[] classes = new String[]{pkgName + "Int_Field", pkgName + "Int_Property", pkgName + "Integer_Field", pkgName + "Integer_Property", pkgName + "Long_Field", pkgName + "Long_Property", pkgName + "LongClass_Field", pkgName + "LongClass_Property", pkgName + "Short_Field", pkgName + "Short_Property", pkgName + "ShortClass_Field", pkgName + "ShortClass_Property", pkgName + "Timestamp_Field", pkgName + "Timestamp_Property"};
        return this.createDeploymentJar("jpa_core_annotations_version3.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupLongData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupLongData");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createLongTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void longFieldTest() throws Exception {
        boolean pass = false;
        try {
            Long_Field a = (Long_Field)this.getEntityManager().find(Long_Field.class, (Object)"1");
            if (a != null) {
                logger.log(System.Logger.Level.TRACE, "version:" + a.getVersion());
                long version = a.getVersion();
                a.setName("two");
                this.getEntityTransaction().begin();
                this.getEntityManager().merge((Object)a);
                this.getEntityManager().flush();
                this.getEntityTransaction().commit();
                Long_Field a1 = (Long_Field)this.getEntityManager().find(Long_Field.class, (Object)"1");
                if (a1 != null) {
                    if (a1.getVersion() > version) {
                        logger.log(System.Logger.Level.TRACE, "version:" + a1.getVersion());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get a greater version after a modification:" + a1.getVersion());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Second find returned null result");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("shortFieldTest failed");
        }
    }

    @Test
    public void longPropertyTest() throws Exception {
        boolean pass = false;
        try {
            Long_Property a = (Long_Property)this.getEntityManager().find(Long_Property.class, (Object)"2");
            if (a != null) {
                logger.log(System.Logger.Level.TRACE, "version:" + a.getBasicLong());
                long version = a.getBasicLong();
                a.setName("two");
                this.getEntityTransaction().begin();
                this.getEntityManager().merge((Object)a);
                this.getEntityManager().flush();
                this.getEntityTransaction().commit();
                Long_Property a1 = (Long_Property)this.getEntityManager().find(Long_Property.class, (Object)"2");
                if (a1 != null) {
                    if (a1.getBasicLong() > version) {
                        logger.log(System.Logger.Level.TRACE, "version:" + a1.getBasicLong());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get a greater version after a modification:" + a1.getBasicLong());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Second find returned null result");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("shortPropertyTest failed");
        }
    }

    @Test
    public void longClassFieldTest() throws Exception {
        boolean pass = false;
        try {
            LongClass_Field a = (LongClass_Field)this.getEntityManager().find(LongClass_Field.class, (Object)"3");
            if (a != null) {
                logger.log(System.Logger.Level.TRACE, "version:" + a.getVersion());
                Long version = a.getVersion();
                a.setName("two");
                this.getEntityTransaction().begin();
                this.getEntityManager().merge((Object)a);
                this.getEntityManager().flush();
                this.getEntityTransaction().commit();
                LongClass_Field a1 = (LongClass_Field)this.getEntityManager().find(LongClass_Field.class, (Object)"3");
                if (a1 != null) {
                    if (a1.getVersion() > version) {
                        logger.log(System.Logger.Level.TRACE, "version:" + a1.getVersion());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get a greater version after a modification:" + a1.getVersion());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Second find returned null result");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("shortClassFieldTest failed");
        }
    }

    @Test
    public void longClassPropertyTest() throws Exception {
        boolean pass = false;
        try {
            LongClass_Property a = (LongClass_Property)this.getEntityManager().find(LongClass_Property.class, (Object)"4");
            if (a != null) {
                logger.log(System.Logger.Level.TRACE, "version:" + a.getBasicLong());
                Long version = a.getBasicLong();
                a.setName("two");
                this.getEntityTransaction().begin();
                this.getEntityManager().merge((Object)a);
                this.getEntityManager().flush();
                this.getEntityTransaction().commit();
                LongClass_Property a1 = (LongClass_Property)this.getEntityManager().find(LongClass_Property.class, (Object)"4");
                if (a1 != null) {
                    if (a1.getBasicLong() > version) {
                        logger.log(System.Logger.Level.TRACE, "version:" + a1.getBasicLong());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get a greater version after a modification:" + a1.getBasicLong());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Second find returned null result");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("shortClassPropertyTest failed");
        }
    }

    public void createLongTestData() {
        logger.log(System.Logger.Level.TRACE, "createLongTestData");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)new Long_Field("1"));
            this.getEntityManager().persist((Object)new Long_Property("2"));
            this.getEntityManager().persist((Object)new LongClass_Field("3", new Long(0L)));
            this.getEntityManager().persist((Object)new LongClass_Property("4", new Long(0L)));
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createLongTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }
}

