/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.elementcollection;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.elementcollection.A;
import ee.jakarta.tck.persistence.core.annotations.elementcollection.Address;
import java.util.HashSet;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client1
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] xmlFile = new String[]{"myMappingFile.xml"};
        String[] classes = new String[]{pkgName + "A", pkgName + "Address", pkgName + "Customer", pkgName + "CustomerXML"};
        return this.createDeploymentJar("jpa_core_annotations_elementcollection1.jar", pkgNameWithoutSuffix, classes, xmlFile);
    }

    @BeforeEach
    public void setupA() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeATestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void elementCollectionEmbeddableType() throws Exception {
        boolean pass = false;
        A aRef = null;
        try {
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA", "01801");
            Address addr2 = new Address("Some Address", "Boston", "MA", "01803");
            HashSet<Address> s1 = new HashSet<Address>();
            s1.add(addr1);
            s1.add(addr2);
            aRef = new A("1", "bean1", 1);
            aRef.setAddress(s1);
            logger.log(System.Logger.Level.TRACE, "Persisting A");
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)aRef);
            this.getEntityTransaction().commit();
            this.getEntityTransaction().begin();
            A newA = this.findA("1");
            Set<Address> newAddressSet = newA.getAddress();
            this.dumpAddresses(newAddressSet);
            boolean pass1 = false;
            boolean pass2 = false;
            boolean pass3 = true;
            for (Address addr : newAddressSet) {
                if (addr != null) {
                    if (addr.getStreet().equals("1 Network Drive") && addr.getCity().equals("Burlington") && addr.getState().equals("MA") && addr.getZip().equals("01801")) {
                        pass1 = true;
                        logger.log(System.Logger.Level.TRACE, "pass1 = " + pass1);
                    }
                    if (!addr.getStreet().equals("Some Address") || !addr.getCity().equals("Boston") || !addr.getState().equals("MA") || !addr.getZip().equals("01803")) continue;
                    pass2 = true;
                    logger.log(System.Logger.Level.TRACE, "pass2 = " + pass2);
                    continue;
                }
                logger.log(System.Logger.Level.TRACE, "address=null");
                pass3 = false;
            }
            if (pass1 && pass2 && pass3) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("elementCollectionEmbeddableType failed");
        }
    }

    private A findA(String id) {
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private void dumpAddresses(Set<Address> addr) {
        logger.log(System.Logger.Level.TRACE, "address Data");
        logger.log(System.Logger.Level.TRACE, "---------------");
        if (addr != null) {
            logger.log(System.Logger.Level.TRACE, "size=" + addr.size());
            int elem = 1;
            for (Address v : addr) {
                logger.log(System.Logger.Level.TRACE, "- Element #" + elem++);
                logger.log(System.Logger.Level.TRACE, "  street=" + v.getStreet() + ", city=" + v.getCity() + ", state=" + v.getState() + ", zip=" + v.getZip());
            }
        } else {
            logger.log(System.Logger.Level.TRACE, "  address=NULL");
        }
    }

    @AfterEach
    public void cleanupA() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeATestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeATestData() {
        logger.log(System.Logger.Level.TRACE, "removeATestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from A_ADDRESS").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from AEC").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

