/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.access.field;

import ee.jakarta.tck.persistence.core.annotations.access.field.Client;
import ee.jakarta.tck.persistence.core.annotations.access.field.DataTypes2;
import jakarta.persistence.TypedQuery;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client4
extends Client {
    private static final System.Logger logger = System.getLogger(Client4.class.getName());
    private final int TD4_YEAR = 1989;
    private final int TD4_QUARTER = 4;
    private final int TD4_MONTH = 11;
    private final int TD4_DAY = 17;
    private final int TD4_HOUR = 11;
    private final int TD4_MINUTE = 23;
    private final int TD4_SECOND = 36;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client4.class.getPackageName();
        String pkgName = Client4.class.getPackageName() + ".";
        String[] classes = new String[]{pkgName + "DataTypes", pkgName + "DataTypes2", "ee.jakarta.tck.persistence.core.types.common.Grade"};
        return this.createDeploymentJar("jpa_core_annotations_access_field4.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup3");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData4();
            logger.log(System.Logger.Level.TRACE, "Done creating test data");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void testExtractDateYear() throws Exception {
        try {
            TypedQuery q1 = this.getEntityManager().createQuery("SELECT EXTRACT(YEAR FROM d.id) FROM DataTypes2 d WHERE d.id = :id", Number.class);
            q1.setParameter("id", (Object)this.t4Date());
            long y = ((Number)q1.getSingleResult()).longValue();
            System.out.println("DATETIME -- YEAR: " + y);
            if (y != 1989L) {
                throw new Exception("EXTRACT(YEAR FROM date) returned wrong value: expeted 1989 but got " + y);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    @Test
    public void testExtractDateQuarter() throws Exception {
        try {
            TypedQuery q1 = this.getEntityManager().createQuery("SELECT EXTRACT(QUARTER FROM d.id) FROM DataTypes2 d WHERE d.id = :id", Number.class);
            q1.setParameter("id", (Object)this.t4Date());
            long q = ((Number)q1.getSingleResult()).longValue();
            if (q != 4L) {
                throw new Exception("EXTRACT(QUARTER FROM date) returned wrong value: expeted 4 but got " + q);
            }
            System.out.println("DATETIME -- QUARTER: " + q);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    @Test
    public void testExtractDateMonth() throws Exception {
        try {
            TypedQuery q1 = this.getEntityManager().createQuery("SELECT EXTRACT(MONTH FROM d.id) FROM DataTypes2 d WHERE d.id = :id", Number.class);
            q1.setParameter("id", (Object)this.t4Date());
            long m = ((Number)q1.getSingleResult()).longValue();
            if (m != 11L) {
                throw new Exception("EXTRACT(MONTH FROM date) returned wrong value: expeted 11 but got " + m);
            }
            System.out.println("DATETIME -- MONTH: " + m);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    @Test
    public void testExtractDateDay() throws Exception {
        try {
            TypedQuery q1 = this.getEntityManager().createQuery("SELECT EXTRACT(DAY FROM d.id) FROM DataTypes2 d WHERE d.id = :id", Number.class);
            q1.setParameter("id", (Object)this.t4Date());
            long d = ((Number)q1.getSingleResult()).longValue();
            if (d != 17L) {
                throw new Exception("EXTRACT(DAY FROM date) returned wrong value: expeted 17 but got " + d);
            }
            System.out.println("DATETIME -- DAY: " + d);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    @Test
    public void testExtractTimeHour() throws Exception {
        try {
            TypedQuery q1 = this.getEntityManager().createQuery("SELECT EXTRACT(HOUR FROM d.timeData) FROM DataTypes2 d WHERE d.id = :id", Number.class);
            q1.setParameter("id", (Object)this.t4Date());
            long h = ((Number)q1.getSingleResult()).longValue();
            if (h != 11L) {
                throw new Exception("EXTRACT(HOUR FROM time) returned wrong value: expeted 11 but got " + h);
            }
            System.out.println("DATETIME -- HOUR: " + h);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    @Test
    public void testExtractTimeMinute() throws Exception {
        try {
            TypedQuery q1 = this.getEntityManager().createQuery("SELECT EXTRACT(MINUTE FROM d.timeData) FROM DataTypes2 d WHERE d.id = :id", Number.class);
            q1.setParameter("id", (Object)this.t4Date());
            long m = ((Number)q1.getSingleResult()).longValue();
            if (m != 23L) {
                throw new Exception("EXTRACT(MINUTE FROM time) returned wrong value: expeted 23 but got " + m);
            }
            System.out.println("DATETIME -- MINUTE: " + m);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    @Test
    public void testExtractTimeSecond() throws Exception {
        try {
            TypedQuery q1 = this.getEntityManager().createQuery("SELECT EXTRACT(SECOND FROM d.timeData) FROM DataTypes2 d WHERE d.id = :id", Number.class);
            q1.setParameter("id", (Object)this.t4Date());
            long s = ((Number)q1.getSingleResult()).longValue();
            if (s != 36L) {
                throw new Exception("EXTRACT(SECOND FROM time) returned wrong value: expeted 36 but got " + s);
            }
            System.out.println("DATETIME -- SECOND: " + s);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    @Test
    public void testExtractDateTimeYear() throws Exception {
        try {
            TypedQuery q1 = this.getEntityManager().createQuery("SELECT EXTRACT(YEAR FROM d.tsData) FROM DataTypes2 d WHERE d.id = :id", Number.class);
            q1.setParameter("id", (Object)this.t4Date());
            long y = ((Number)q1.getSingleResult()).longValue();
            System.out.println("DATETIME -- YEAR: " + y);
            if (y != 1989L) {
                throw new Exception("EXTRACT(YEAR FROM timestamp) returned wrong value: expeted 1989 but got " + y);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    @Test
    public void testExtractDateTimeQuarter() throws Exception {
        try {
            TypedQuery q1 = this.getEntityManager().createQuery("SELECT EXTRACT(QUARTER FROM d.tsData) FROM DataTypes2 d WHERE d.id = :id", Number.class);
            q1.setParameter("id", (Object)this.t4Date());
            long q = ((Number)q1.getSingleResult()).longValue();
            if (q != 4L) {
                throw new Exception("EXTRACT(QUARTER FROM timestamp) returned wrong value: expeted 4 but got " + q);
            }
            System.out.println("DATETIME -- QUARTER: " + q);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    @Test
    public void testExtractDateTimeMonth() throws Exception {
        try {
            TypedQuery q1 = this.getEntityManager().createQuery("SELECT EXTRACT(MONTH FROM d.tsData) FROM DataTypes2 d WHERE d.id = :id", Number.class);
            q1.setParameter("id", (Object)this.t4Date());
            long m = ((Number)q1.getSingleResult()).longValue();
            if (m != 11L) {
                throw new Exception("EXTRACT(MONTH FROM timestamp) returned wrong value: expeted 11 but got " + m);
            }
            System.out.println("DATETIME -- MONTH: " + m);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    @Test
    public void testExtractDateTimeDay() throws Exception {
        try {
            TypedQuery q1 = this.getEntityManager().createQuery("SELECT EXTRACT(DAY FROM d.tsData) FROM DataTypes2 d WHERE d.id = :id", Number.class);
            q1.setParameter("id", (Object)this.t4Date());
            long d = ((Number)q1.getSingleResult()).longValue();
            if (d != 17L) {
                throw new Exception("EXTRACT(DAY FROM timestamp) returned wrong value: expeted 17 but got " + d);
            }
            System.out.println("DATETIME -- DAY: " + d);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    @Test
    public void testExtractDateTimeHour() throws Exception {
        try {
            TypedQuery q1 = this.getEntityManager().createQuery("SELECT EXTRACT(HOUR FROM d.tsData) FROM DataTypes2 d WHERE d.id = :id", Number.class);
            q1.setParameter("id", (Object)this.t4Date());
            long h = ((Number)q1.getSingleResult()).longValue();
            if (h != 11L) {
                throw new Exception("EXTRACT(HOUR FROM timestamp) returned wrong value: expeted 11 but got " + h);
            }
            System.out.println("DATETIME -- HOUR: " + h);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    @Test
    public void testExtractDateTimeMinute() throws Exception {
        try {
            TypedQuery q1 = this.getEntityManager().createQuery("SELECT EXTRACT(MINUTE FROM d.tsData) FROM DataTypes2 d WHERE d.id = :id", Number.class);
            q1.setParameter("id", (Object)this.t4Date());
            long m = ((Number)q1.getSingleResult()).longValue();
            if (m != 23L) {
                throw new Exception("EXTRACT(MINUTE FROM timestamp) returned wrong value: expeted 23 but got " + m);
            }
            System.out.println("DATETIME -- MINUTE: " + m);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    @Test
    public void testExtractDateTimeSecond() throws Exception {
        try {
            TypedQuery q1 = this.getEntityManager().createQuery("SELECT EXTRACT(SECOND FROM d.tsData) FROM DataTypes2 d WHERE d.id = :id", Number.class);
            q1.setParameter("id", (Object)this.t4Date());
            long s = ((Number)q1.getSingleResult()).longValue();
            if (s != 36L) {
                throw new Exception("EXTRACT(SECOND FROM timestamp) returned wrong value: expeted 36 but got " + s);
            }
            System.out.println("DATETIME -- SECOND: " + s);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    private Date t4Date() {
        GregorianCalendar cal = new GregorianCalendar(1989, 10, 17, 11, 23, 36);
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        return Date.valueOf(ts.toLocalDateTime().toLocalDate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestData4() {
        logger.log(System.Logger.Level.TRACE, "createTestData4");
        GregorianCalendar cal = new GregorianCalendar(1989, 10, 17, 11, 23, 36);
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        Date dt = Date.valueOf(ts.toLocalDateTime().toLocalDate());
        Time tm = Time.valueOf(ts.toLocalDateTime().toLocalTime());
        try {
            this.getEntityTransaction().begin();
            DataTypes2 dataTypes2 = new DataTypes2(dt, tm, ts);
            this.getEntityManager().persist((Object)dataTypes2);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }
}

