/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.util.Locale;

public class MainFrame {
    private static Frame frame;
    private static boolean inUse;
    private static LayoutManager savedLayout;
    private static Component[] savedComponents;
    private static String savedName;
    private static Rectangle savedBounds;
    private static Color savedBackground;
    private static Color savedForeground;
    private static String savedTitle;
    private static int savedState;
    private static Image savedIconImage;
    private static Cursor savedCursor;
    private static Font savedFont;
    private static Locale savedLocale;
    private static boolean savedResizable;
    private static boolean savedEnabled;
    private static String initialTitle;
    private static int initialState;
    private static Image initialIconImage;
    private static Cursor initialCursor;
    private static Font initialFont;
    private static Locale initialLocale;
    private static boolean initialResizable;
    private static boolean initialEnabled;

    public static synchronized void setContext(Container c) {
        MainFrame.setFrame((Frame)c);
    }

    public static synchronized void setFrame(Frame f) {
        frame = f;
    }

    public static Container getContext() {
        try {
            return MainFrame.acquireFrame();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public static synchronized Frame acquireFrame() throws InterruptedException {
        if (frame == null) {
            frame = new Frame("JT Harness Default Frame");
            initialTitle = frame.getTitle();
            initialState = frame.getState();
            initialIconImage = frame.getIconImage();
            initialCursor = frame.getCursor();
            initialFont = frame.getFont();
            initialLocale = frame.getLocale();
            initialResizable = frame.isResizable();
            initialEnabled = frame.isEnabled();
        }
        while (inUse) {
            MainFrame.class.wait();
        }
        inUse = true;
        savedLayout = frame.getLayout();
        savedComponents = frame.getComponents();
        savedName = frame.getName();
        savedBounds = frame.getBounds();
        Color bg = frame.getBackground();
        savedBackground = bg == null ? SystemColor.window : bg;
        Color fg = frame.getForeground();
        savedForeground = fg == null ? SystemColor.windowText : fg;
        savedTitle = frame.getTitle();
        savedState = frame.getState();
        savedIconImage = frame.getIconImage();
        savedCursor = frame.getCursor();
        savedFont = frame.getFont();
        savedLocale = frame.getLocale();
        savedResizable = frame.isResizable();
        savedEnabled = frame.isEnabled();
        frame.setLayout(null);
        frame.removeAll();
        frame.setLayout(new FlowLayout());
        frame.setTitle(initialTitle);
        frame.setState(initialState);
        frame.setIconImage(initialIconImage);
        frame.setCursor(initialCursor);
        frame.setFont(initialFont);
        frame.setLocale(initialLocale);
        frame.setResizable(initialResizable);
        frame.setEnabled(initialEnabled);
        return frame;
    }

    public static void restoreContext(Container c) {
        MainFrame.releaseFrame((Frame)c);
    }

    public static synchronized void releaseFrame(Frame f) {
        if (f == null) {
            return;
        }
        if (f != frame) {
            throw new IllegalStateException("wrong frame");
        }
        if (!inUse) {
            throw new IllegalStateException("frame not acquired");
        }
        frame.setLayout(null);
        frame.removeAll();
        frame.setForeground(savedForeground);
        frame.setBackground(savedBackground);
        frame.setBounds(savedBounds);
        frame.setName(savedName);
        for (int i = 0; i < savedComponents.length; ++i) {
            frame.add(savedComponents[i]);
        }
        frame.setLayout(savedLayout);
        frame.setTitle(savedTitle);
        frame.setState(savedState);
        frame.setIconImage(savedIconImage);
        frame.setCursor(savedCursor);
        frame.setFont(savedFont);
        frame.setLocale(savedLocale);
        frame.setResizable(savedResizable);
        frame.setEnabled(savedEnabled);
        inUse = false;
        MainFrame.class.notify();
    }
}

