/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.web;

import com.sun.ant.taskdefs.common.DescriptorHandler;
import java.io.File;
import java.util.Hashtable;
import org.apache.tools.ant.Task;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class WebDescriptorHandler
extends DescriptorHandler {
    private static final int STATE_LOOKING_WEBWAR = 1;
    private static final String SERVLET_MAPPING = "servlet-mapping";
    private static final String SERVLET_NAME = "servlet-name";
    private static final String SERVLET_CLASS = "servlet-class";
    private static final String SERVLET_FILTER_CLASS = "filter-class";
    private static final String SERVLET_LISTENER_CLASS = "listener-class";
    private static final String JSP_FILE = "jsp-file";
    private static final String ERROR_PAGE = "error-page";
    private static final String LOCATION = "location";
    private static final String WEB_APP = "web-app";
    private static final String EJB_REF = "ejb-ref";
    private static final String SERVLET = "servlet";
    private static final String BEAN_CLASS = "ejb-class";
    private static final String HOME_INTERFACE = "home";
    private static final String REMOTE_INTERFACE = "remote";
    protected Hashtable classes;

    public WebDescriptorHandler(Task task, File srcDir) {
        super(task, srcDir);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.classes = new Hashtable();
    }

    public void startElement(String name, AttributeList attrs) throws SAXException {
        this.currentElement = name;
        this.currentText = "";
    }

    public void endElement(String name) throws SAXException {
        this.processElement();
        this.currentText = "";
        this.currentElement = "";
    }

    protected void processElement() {
        if (this.currentElement.equals(SERVLET_CLASS) || this.currentElement.equals(SERVLET_FILTER_CLASS) || this.currentElement.equals(SERVLET_LISTENER_CLASS) || this.currentElement.equals(REMOTE_INTERFACE) || this.currentElement.equals(HOME_INTERFACE)) {
            File classFile = null;
            String className = this.currentText.trim();
            if (!className.startsWith("java.") && !className.startsWith("javax.")) {
                className = className.replace('.', File.separatorChar);
                className = className + ".class";
                classFile = new File(this.srcDir, className);
                this.classes.put(className, classFile);
            }
        } else if (this.currentElement.equals(LOCATION) || this.currentElement.equals(JSP_FILE)) {
            File contentFile = null;
            String contentName = this.currentText.trim();
            if (contentName.endsWith(".jsp") || contentName.endsWith(".html") || contentName.endsWith(".htm")) {
                contentFile = new File(this.srcDir, contentName);
                this.files.put(contentName, contentFile);
            }
        }
    }

    public Hashtable getClasses() {
        return this.classes == null ? new Hashtable() : this.classes;
    }
}

