/*
 * Copyright (c) 2013, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.ts.tests.jpa.se.schemaGeneration.annotations.uniqueConstraint;

import jakarta.persistence.*;

@Entity
@Table(name = "SCHEMAGENSIMPLE", uniqueConstraints = @UniqueConstraint(name = "MYUNIQUECONSTRAINT", columnNames = {
    "ID", "NAME" }))
public class Simple implements java.io.Serializable {

  // ===========================================================
  // instance variables
  int id;

  String name;

  // ===========================================================
  // constructors
  public Simple() {
  }

  public Simple(int id) {
    this.id = id;
  }

  public Simple(int id, String name) {
    this.id = id;
    this.name = name;
  }

  @Id
  @Column(name = "ID")
  public int getId() {
    return id;
  }

  public void setId(int id) {
    this.id = id;
  }

  @Column(name = "NAME")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public int hashCode() {

    return this.getId() + this.getName().hashCode();
  }

  @Override
  public boolean equals(Object o) {
    // check for self-comparison
    if (this == o)
      return true;
    if (!(o instanceof Simple))
      return false;

    Simple o1 = (Simple) o;

    boolean result = false;

    if (this.getId() == o1.getId() && this.getName().equals(o1.getName())) {
      result = true;
    }

    return result;
  }

  @Override
  public String toString() {
    StringBuilder result = new StringBuilder();
    result.append(this.getClass().getSimpleName() + "[");
    result.append("id: " + getId());
    if (getName() != null) {
      result.append(", name: " + getName());
    } else {
      result.append(", name: null");
    }
    result.append("]");
    return result.toString();
  }

}
